/*
 * @(#)MQAutoCreateDestPermission.java	1.2 05/11/17
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.auth.jaas;

/**
 * This class is for MQ auto-create destination permissions.  It contains
 * a name (also referred to as a "target name") but no actions list; you 
 * either have the named permission or you don't.
 *
 * @author      Amy Kang
 */

public final class MQAutoCreateDestPermission extends MQBasicPermission 
{ 

	private static final long serialVersionUID = -8834137571861608842L;

    /**
     *
     */
    public MQAutoCreateDestPermission(String name) {
        super(name);
    }

    public void validateName(String name) throws IllegalArgumentException {
        if (!name.equals(PermissionFactory.DEST_QUEUE) && 
            !name.equals(PermissionFactory.DEST_TOPIC)) {
            throw new IllegalArgumentException("invalidate name "+name);
        }
    }
}
