/*
 * @(#)MQAddressList.java	1.3 03/21/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.io;

import java.util.Random;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.net.MalformedURLException;

/**
 * This class represents broker address URL.
 */
public class MQAddressList extends ArrayList {

    protected MQAddressList() {}

    protected com.sun.messaging.jmq.io.MQAddress createMQAddress(String s)  
         throws java.net.MalformedURLException
   {
            return MQAddress.getMQAddress(s);
    }

    public static MQAddressList createAddressList(String addrs)
        throws MalformedURLException {
        MQAddressList alist = new MQAddressList();
        StringTokenizer st = new StringTokenizer(addrs, " ,");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            MQAddress a;

            alist.add(alist.createMQAddress(s));
        }

        return alist;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < size(); i++) {
            ret = ret + "addr[" + i + "] :\t" + get(i) + "\n";
        }

        return ret;
    }

}

/*
 * EOF
 */
