/*
 * @(#)ConnectException.java	1.1 06/05/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jms.JMSException;
import java.io.*;
import javax.jms.*;

/**
 * This is the connection failure exception thrown by the
 * ConnectionInitiator class when more than one broker addresses are
 * used. It encapsulates the last transport exception (cause) for each
 * address in the list.
 */
public class ConnectException extends com.sun.messaging.jms.JMSException {
	private Exception[] elist = null;
    private String[] alist = null;

    public ConnectException(String reason, String errorCode,
        Exception[] elist, String[] alist) {
        super(reason, errorCode);
        this.elist = elist;
        this.alist = alist;
    }

    /**
     * Print all the linked exceptions.
     */
    public
    void printStackTrace(PrintStream s) {
        super.printStackTrace(s);

        if (elist == null)
            return;

        for (int i = 0; i < elist.length; i++) {
            s.println("\n###### Connect exception for : " + alist[i]);
            elist[i].printStackTrace(s);
        }
    }

    /**
     * Print all the linked exceptions.
     */
    public
    void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);

        if (elist == null)
            return;

        for (int i = 0; i < elist.length; i++) {
            s.println("\n###### Connect exception for : " + alist[i]);
            elist[i].printStackTrace(s);
        }
    }
}
/*
 * EOF
 */
