/*
 * @(#)ConnectionMetaDataImpl.java	1.14 05/05/23
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import com.sun.messaging.*;

import java.util.Enumeration;
import java.util.Vector;

import com.sun.messaging.jmq.Version;

/** ConnectionMetaData provides information describing the Connection.
  *
  * @version     1.0 - 13 March 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  */

public class ConnectionMetaDataImpl implements ConnectionMetaData {
    protected static final Version version = new Version();
    protected static final String JMSVersion = "1.1";
    protected static final int JMSMajorVersion = 1;
    protected static final int JMSMinorVersion = 1;
    public static final String JMSProviderName = version.getProductName();
    public static final String providerVersion = "4.0";
    protected static final int providerMajorVersion = 4;
    protected static final int providerMinorVersion = 0;

    public static final String JMSXGroupID = "JMSXGroupID";
    public static final String JMSXGroupSeq = "JMSXGroupSeq";

    public static final String JMSXAppID = "JMSXAppID";
    public static final String JMSXConsumerTXID = "JMSXConsumerTXID";
    public static final String JMSXProducerTXID = "JMSXProducerTXID";
    public static final String JMSXRcvTimestamp = "JMSXRcvTimestamp";
    public static final String JMSXUserID = "JMSXUserID";

    protected boolean setJMSXAppID = false;
    protected boolean setJMSXConsumerTXID = false;
    protected boolean setJMSXProducerTXID = false;
    protected boolean setJMSXRcvTimestamp = false;
    protected boolean setJMSXUserID = false;

    protected Vector supportedProperties = new Vector(7);

    protected ConnectionImpl connection = null;

    protected ConnectionMetaDataImpl(ConnectionImpl connection) {
        //current connection
        this.connection = connection;
        init();
    }

    private void init() {
        String tmp = null;

        //the following two properties are supported by default.
        //They are set by client apps if needed.
        supportedProperties.addElement(JMSXGroupID);
        supportedProperties.addElement(JMSXGroupSeq);

        //test if set app id requested
        tmp = connection.getProperty(ConnectionConfiguration.imqSetJMSXAppID);
        if ( Boolean.valueOf(tmp).booleanValue() ) {
            setJMSXAppID = true;
            supportedProperties.addElement(JMSXAppID);
        }

        //test if set consumer TX ID requested
        tmp = connection.getProperty(ConnectionConfiguration.imqSetJMSXConsumerTXID);
        if ( Boolean.valueOf(tmp).booleanValue() ) {
            setJMSXConsumerTXID = true;
            supportedProperties.addElement(JMSXConsumerTXID);
        }

        //test if set producer TX id requested
        tmp = connection.getProperty(ConnectionConfiguration.imqSetJMSXProducerTXID);
        if ( Boolean.valueOf(tmp).booleanValue() ) {
            setJMSXProducerTXID = true;
            supportedProperties.addElement(JMSXProducerTXID);
        }

        //test if set receive time stamp requested
        tmp = connection.getProperty(ConnectionConfiguration.imqSetJMSXRcvTimestamp);
        if ( Boolean.valueOf(tmp).booleanValue() ) {
            setJMSXRcvTimestamp = true;
            supportedProperties.addElement(JMSXRcvTimestamp);
        }

        //test if set user id requested
        tmp = connection.getProperty(ConnectionConfiguration.imqSetJMSXUserID);
        if ( Boolean.valueOf(tmp).booleanValue() ) {
            setJMSXUserID = true;
            supportedProperties.addElement(JMSXUserID);
        }

    }

    /** Get the JMS version.
      *
      * @return the JMS version.
      *
      * @exception JMSException if some internal error occurs in
      *                         JMS implementation during the meta-data
      *                         retrieval.
      */

    public String
    getJMSVersion() throws JMSException {
        return JMSVersion;
    }


    /** Get the JMS major version number.
      *
      * @return the JMS major version number.
      *
      * @exception JMSException if some internal error occurs in
      *                         JMS implementation during the meta-data
      *                         retrieval.
      */

    public int
    getJMSMajorVersion() throws JMSException {
        return JMSMajorVersion;
    }


    /** Get the JMS minor version number.
      *
      * @return the JMS minor version number.
      *
      * @exception JMSException if some internal error occurs in
      *                         JMS implementation during the meta-data
      *                         retrieval.
      */

    public int
    getJMSMinorVersion() throws JMSException {
        return JMSMinorVersion;
    }


    /** Get the JMS provider name.
      *
      * @return the JMS provider name.
      *
      * @exception JMSException if some internal error occurs in
      *                         JMS implementation during the meta-data
      *                         retrieval.
      */

    public String
    getJMSProviderName() throws JMSException {
        return JMSProviderName;
    }


    /** Get the JMS provider version.
      *
      * @return the JMS provider version.
      *
      * @exception JMSException if some internal error occurs in
      *                         JMS implementation during the meta-data
      *                         retrieval.
      */

    public String
    getProviderVersion() throws JMSException {
        return providerVersion;
    }


    /** Get the JMS provider major version number.
      *
      * @return the JMS provider major version number.
      *
      * @exception JMSException if some internal error occurs in
      *                         JMS implementation during the meta-data
      *                         retrieval.
      */

    public int
    getProviderMajorVersion() throws JMSException {
        return providerMajorVersion;
    }


    /** Get the JMS provider minor version number.
      *
      * @return the JMS provider minor version number.
      *
      * @exception JMSException if some internal error occurs in
      *                         JMS implementation during the meta-data
      *                         retrieval.
      */

    public int
    getProviderMinorVersion() throws JMSException {
        return providerMinorVersion;
    }


    /** Get an enumeration of JMSX Property Names.
      *
      * @return an Enumeration of JMSX PropertyNames.
      *
      * @exception JMSException if some internal error occurs in
      *                         JMS implementation during the property
      *                         names retrieval.
      */

    public Enumeration
    getJMSXPropertyNames() throws JMSException {
        return supportedProperties.elements();
    }

}
