/*
 * @(#)JMSXATopicConnectionImpl.java	1.4 02/03/27
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import java.util.Properties;

import com.sun.jms.spi.xa.*;

/** An XATopicConnection is an active connection to a JMS Pub/Sub provider.
  * A client uses an XATopicConnection to create one or more XATopicSessions
  * for producing and consuming messages.
  *
  * @version     1.4 02/03/27
  * @author      George Tharakan
  *
  * @see javax.jms.XAConnection
  * @see javax.jms.XATopicConnectionFactory
  */

public class JMSXATopicConnectionImpl extends XATopicConnectionImpl implements JMSXATopicConnection {

    public
    JMSXATopicConnectionImpl(Properties configuration, String username,
                        String password, String type) throws JMSException {
        super(configuration, username, password, type);
    }

    /**
     * Create an XATopicSession
     *  
     * @param transacted      ignored.
     * @param acknowledgeMode ignored.
     *  
     * @return a newly created XA topic session.
     *  
     * @exception JMSException if JMS Connection fails to create a
     *                         XA topic session due to some internal error.
     */ 
    public JMSXATopicSession
    createXATopicSession(boolean transacted,
                       int acknowledgeMode) throws JMSException {
 
        checkConnectionState();
 
        //disallow to set client ID after this action.
        setClientIDFlag();
 
        return new JMSXATopicSessionImpl(this, transacted, acknowledgeMode);
    }

    /**
     * get a TopicConnection associated with this XATopicConnection object.
     *  
     * @return a TopicConnection.
     */ 
    public TopicConnection getTopicConnection() {
        return (TopicConnection) this;
    }
}

