/*
 * @(#)JMSXAWrappedLock.java	1.1 04/10/17
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

/**
  * JMSXAWrappedLock  A simple lock used by JMSXAWrapped classes
  *
  * @author  Amy Kang
  */

public class JMSXAWrappedLock {

    private Thread owner = null;
    private boolean locked = false;

    public JMSXAWrappedLock() {};

    public synchronized void acquireLock() {
        Thread me = Thread.currentThread();

        while (locked && owner != me) {
            try {
            wait();
            } catch (InterruptedException e) {}
        }

        locked = true;
        owner = me;
    }

    /**
     * caller must have called acquireLock */

    public synchronized void releaseLock() {
        Thread me = Thread.currentThread();

        locked = false;
        owner = null;
        notifyAll();
    }
}

