/*
 * @(#)JMSXAWrappedTransactionListener.java	1.1 04/10/17
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.JMSException;
import javax.transaction.xa.Xid;


/**
  * JMSXAWrappedTransactionListener 
  *
  * @author  Amy Kang
  * @see com.sun.messaging.jmq.jmsclient.JMSXAWrappedXAResourceImpl
  */

public interface JMSXAWrappedTransactionListener {

    public void beforeTransactionStart() throws JMSException;
    public void afterTransactionStart(Xid foreignXid, boolean started);
    public void beforeTransactionComplete();
    public void afterTransactionComplete(Xid foreignXid, boolean completed);
}
