/*
 * @(#)QueueSessionImpl.java	1.17 04/05/14
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import com.sun.messaging.AdministeredObject;

/** A QueueSession provides methods for creating QueueReceiver's,
  * QueueSender's, QueueBrowser's and TemporaryQueues.
  *
  * <P>If there are messages that have been received but not acknowledged
  * when a QueueSession terminates, these messages will be retained and
  * redelivered when a consumer next accesses the queue.
  *
  * @version     1.0 - 14 May 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         javax.jms.Session
  * @see         javax.jms.QueueConnection#createQueueSession(boolean, int)
  * @see         javax.jms.XAQueueSession#getQueueSession()
  */

public class QueueSessionImpl extends UnifiedSessionImpl implements QueueSession {

    public QueueSessionImpl
            (ConnectionImpl connection, boolean transacted, int ackMode) throws JMSException {

        super (connection, transacted, ackMode);
    }

    public QueueSessionImpl
            (ConnectionImpl connection, int ackMode)
            throws JMSException {

        super (connection, ackMode);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param topicName the name of this topic
    *
    * @return a Topic with the given name.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public Topic createTopic(String topicName) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN, "createTopic");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @return a temporary queue identity
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public TemporaryTopic
    createTemporaryTopic() throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createTemporaryTopic");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param topic the non-temporary topic to subscribe to
    * @param name the name used to identify this subscription.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public TopicSubscriber
    createDurableSubscriber(Topic topic, String name) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createDurableSubscriber");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param topic the non-temporary topic to subscribe to
    * @param name the name used to identify this subscription.
    * @param messageSelector only messages with properties matching the
    * message selector expression are delivered. This value may be null.
    * @param noLocal if set, inhibits the delivery of messages published
    * by its own connection.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public TopicSubscriber
    createDurableSubscriber(Topic topic,
                            String name,
                String messageSelector,
                boolean noLocal) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createDurableSubscriber");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param name the name used to identify this subscription.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public void
    unsubscribe(String name) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "unsubscribe");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

}
