/*
 * @(#)HelpPrinter.java	1.2 00/10/15
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;

/** 
 * This class prints the usage/help statements for the jmqobjmgr.
 *
 */
public class HelpPrinter {

    private static BrokerResources br = Globals.getBrokerResources();

    /**
     * Constructor
     */
    public HelpPrinter() {
    } 

    /**
     * Prints usage, subcommands, options then exits.
     */
    public void printShortHelp() {
	printUsage();
	printSubcommands();
	printOptions();
    }

    /**
     * Prints everything in short help plus
     * attributes, examples then exits.
     */
    public void printLongHelp() {
	printUsage();
	printSubcommands();
	printOptions();

	printExamples();
    }

    private void printUsage() {
	Output.stdOutPrintln(br.getString(br.I_USERMGR_HELP_USAGE));
    }

    private void printSubcommands() {
	/*
	Output.stdOutPrintln(br.getString(br.I_USERMGR_HELP_SUBCOMMANDS));
	*/
    }

    private void printOptions() {
	Output.stdOutPrintln(br.getString(br.I_USERMGR_HELP_OPTIONS));
    }

    private void printExamples() {
	/*
        Output.stdOutPrintln(br.getString(br.I_USERMGR_HELP_EXAMPLES1));
	*/
    }
}
