/*
 * @(#)UserMgrOptions.java	1.9 04/05/18
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.auth.usermgr;

/**
 * Interface containing constants for command line options,
 * property names and values for the JMS Object Administration
 * utility.
 *
 * @version	1.9 04/05/18
 */
public interface UserMgrOptions  {

    /*
     * BEGIN OPTION NAMES
     */

    /**
     * Strings defining what the sub command names are
     */
    public static final String CMD_ADD			= "add";
    public static final String CMD_DELETE		= "delete";
    public static final String CMD_LIST			= "list";
    public static final String CMD_UPDATE		= "update";

    /*
     * Private sub commands - for testing purposes
     */
    public static final String CMD_EXISTS		= ".exists";
    public static final String CMD_GETGROUP		= ".getgroup";
    public static final String CMD_GETGROUPSIZE		= ".getgroupsize";

    /*
     * Options - jmqusermgr specific
     */
    public static final String OPTION_ACTIVE		= "-a";
    public static final String OPTION_PASSWD		= "-p";
    public static final String OPTION_ROLE		= "-g";
    public static final String OPTION_USERNAME		= "-u";
    public static final String OPTION_INSTANCE		= "-i";
    public static final String OPTION_PASSFILE		= "-passfile";

    /*
     * Options - 'Standard'
     */
    public static final String OPTION_FORCE		= "-f";
    public static final String OPTION_SILENTMODE	= "-s";
    public static final String OPTION_SHORT_HELP1	= "-h";
    public static final String OPTION_SHORT_HELP2	= "-help";
    public static final String OPTION_LONG_HELP1	= "-H";
    public static final String OPTION_LONG_HELP2	= "-Help";
    public static final String OPTION_VERSION1		= "-v";
    public static final String OPTION_VERSION2		= "-version";

    /*
     * END OPTION NAMES
     */

    /*
     * BEGIN PROPERTY NAMES/VALUES
     */

    /**
     * Property name representing what command
     * needs to be executed.
     */
    public static String PROP_NAME_CMD			= "cmdtype";

    /*
     * Property values for command types.
     */
    public static String PROP_VALUE_CMD_ADD		= CMD_ADD;
    public static String PROP_VALUE_CMD_DELETE		= CMD_DELETE;
    public static String PROP_VALUE_CMD_LIST		= CMD_LIST;
    public static String PROP_VALUE_CMD_UPDATE		= CMD_UPDATE;

    public static String PROP_VALUE_CMD_EXISTS		= CMD_EXISTS;
    public static String PROP_VALUE_CMD_GETGROUP	= CMD_GETGROUP;
    public static String PROP_VALUE_CMD_GETGROUPSIZE	= CMD_GETGROUPSIZE;

    public static String PROP_NAME_OPTION_ACTIVE	= "active";
    public static String PROP_NAME_OPTION_PASSWD	= "passwd";

    public static String PROP_NAME_OPTION_ROLE		= "role";
    public static String PROP_VALUE_ROLE_ADMIN		= "admin";
    public static String PROP_VALUE_ROLE_USER		= "user";
    public static String PROP_VALUE_ROLE_ANON		= "anonymous";

    public static String PROP_NAME_OPTION_USERNAME	= "username";

    public static String PROP_NAME_OPTION_INSTANCE	= "instance";

    public static String PROP_NAME_OPTION_FORCE		= "force";
    public static String PROP_VALUE_OPTION_FORCE	= "true";

    public static String PROP_NAME_OPTION_SILENTMODE	= "silent";
    public static String PROP_VALUE_OPTION_SILENTMODE	= "true";

    /*
     * Location of user repository
     * e.g. /var/imq/instances/imqbroker/etc/passwd
     */
    public static String PROP_NAME_PASSWORD_FILE	= "pwfile";

    /*
     * Location/name of passfile - file containing
     * user's password that is specified to imqusermgr.
     */
    public static String PROP_NAME_OPTION_PASSFILE	= "passfile";

    /*
     * END PROPERTY NAMES/VALUES
     */
    
    public static final String[] OPTION_ROLE_VALID_VALUES	= {
							    PROP_VALUE_ROLE_ADMIN,
							    PROP_VALUE_ROLE_USER,
							    PROP_VALUE_ROLE_ANON
							};

    /*
     * List of characters that cannot be used in usernames
     */
    public static final char[] OPTION_USERNAME_INVALID_CHARS	= {
							    ':', 
							    '*', 
							    ',', 
							    '\n',
							    '\r'
							};
}

