/*
 * @(#)UserMgrUtils.java	1.2 02/03/18
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import java.io.*;

import com.sun.messaging.jmq.util.Password;

/** 
 * This class contains utility methods used by jmqusermgr.
 */
public class UserMgrUtils implements UserMgrOptions  {

    /**
     * Constructor
     */
    public UserMgrUtils() {
    } 

    /**
     * Return user input.  Throws an exception if an error occurred.
     */
    public static String getUserInput(UserMgrProperties userMgrProps,
			String question) throws UserMgrException  {

        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
	    Output.stdOutPrint(question);
            return in.readLine();

        } catch (IOException ioex) {
	    UserMgrException ex = 
		new UserMgrException(UserMgrException.PROBLEM_GETTING_INPUT);
	    ex.setProperties(userMgrProps);
	    ex.setLinkedException(ioex);
	    
	    throw (ex);
        }
    }    

    /**
     * Return password input.  
     */
    public static String getPasswordInput(UserMgrProperties userMgrProps,
			String question) {

	Password pw = new Password();
	Output.stdOutPrint(question);
	return pw.getPassword();

    }

}    
