/*
 * @(#)HAClusteredBroker.java	1.10 04/21/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.cluster.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.cluster.*;



/**
 * Subclass of ClusteredBroker which contains HA specific information.
 */
public interface HAClusteredBroker extends ClusteredBroker
{
    /**
     * The brokerid assigned to the broker. <P>
     *
     * The name is unique to the cluster (and overrides
     * the superclass implementation).
     *
     * @return the name of the broker
     */
    public String getBrokerName(); 

    /**
     * Gets the UID associated with the store session.
     *
     * @return the store session uid (if known)
     */
    public UID getStoreSessionUID();


    /**
     * Sets the UID associated with the store session.
     *
     * @param uid the new store session uid 
     * @throws IllegalAccessException if the broker does not have
     *               permission to change the broker (e.g. one broker
     *               is updating anothers sessionUID).
     */
    public void setStoreSessionUID(UID uid)
            throws IllegalAccessException;

    /**
     * Retrieves the id of the broker who has taken over this broker's store.
     *
     * @return the broker id of the takeover broker (or null if there is not
     *      a takeover broker).
     */
    public String getTakeoverBroker()
            throws BrokerException;

    /**
     * Returns the heartbeat timestamp associated with this broker.
     *
     * @return the heartbeat in milliseconds
     * @throws BrokerException if the heartbeat can not be retrieve.
     */
    public long getHeartbeat()
            throws BrokerException;
 

    /**
     * Update the timestamp associated with this broker.
     * @return the updated heartbeat in milliseconds
     * @throws BrokerException if the heartbeat can not be set or retrieve.
     */
    public long updateHeartbeat()
            throws BrokerException;

    /**
     * Attempt to take over the persistent state of the broker.
     * 
     * @param force force the takeover
     * @throws IllegalStateException if this broker can not takeover.
     * @return data associated with previous broker
     */
    public TakeoverStoreInfo takeover(boolean force)
            throws BrokerException;
}
