/*
 * @(#)NoCluster.java	1.30 08/31/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.core;

import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

/**
 * Simple message bus implementation which can be used
 * in non-clustered environments.
 */
public class NoCluster implements ClusterBroadcast {

    private static final Object noOwner = new Object();

    private static BrokerAddress noAddress = 
         new BrokerAddress() {
            String address="localhost";

            public Object clone() {
               return this;
            }
            public boolean equals(Object o) {
                return o instanceof BrokerAddress;
            }
            public int hashCode() {
                return address.hashCode();
            }
            public void writeBrokerAddress(DataOutputStream os) 
                throws IOException
            {
            }
             
            public void readBrokerAddress(DataInputStream dis) 
                throws IOException
            {
            }

            public boolean getHAEnabled() { 
                return false; 
            }
            public String getBrokerID() {
                return null; 
            }
            public UID getBrokerSessionUID() { 
                return null; 
            }
            public UID getStoreSessionUID() { 
                return null; 
            }
            public String getInstanceName() { 
                return null; 
            }
         };

    public int getClusterVersion() {
        return VERSION_350;
    }

    public void messageDelivered(SysMessageID id, ConsumerUID uid,
                BrokerAddress ba)
    {
    }

    public Protocol getProtocol() {
        return null;
    }

    /**
     * Set the matchProps for the cluster.
     */
    public void setMatchProps(Properties matchProps) {
    }

    /**
     *
     */
    public boolean waitForConfigSync() {
        return false;
    }



    public void startClusterIO() {
    }

    public void pauseMessageFlow() throws IOException {
    }
    public void resumeMessageFlow() throws IOException {
    }

    public void forwardMessage(PacketReference ref, Collection consumers)
    {
    }

    public void stopClusterIO(boolean requestTakeover) {
    }

    /**
     * Returns the address of this broker.
     * @return <code> BrokerAddress </code> object representing this
     * broker.
     */
    public BrokerAddress getMyAddress() {
        return noAddress;
    }

    private static Map map = Collections.synchronizedMap(
             new HashMap());

    public boolean lockSharedResource(String resource, Object owner) {
        return true;
    }

    public boolean lockDestination(DestinationUID uid, Object owner)
    {
        // unnecessary in single broker implementation
        return true;
    }

    public void unlockDestination(DestinationUID uid, Object owner) {
        // unnecessary in single broker 
    }

    public synchronized boolean lockClientID(String clientid, Object owner, boolean shared)
    {
        if (shared) {
            throw new RuntimeException("shared clientID's not supported w/o cluster");
        }
        String lockid = "clientid:" + clientid;
        if (shared) {
           // no reason to lock in multibroker
           return true;
        }
        return lockResource(lockid, System.currentTimeMillis(), owner);
    }
    public synchronized void unlockClientID(String clientid, Object owner) {
        String lockid = "clientid:" + clientid;
        unlockResource(lockid);
    }

    public boolean getConsumerLock(ConsumerUID uid,
                    DestinationUID duid, int position,
                    int maxActive, Object owner)
            throws BrokerException
    {

        return true;
    }


    public void unlockConsumer(ConsumerUID uid, DestinationUID duid, int position) {
        // for now, do nothing
    }
    

    public boolean lockResource(String id, long timestamp, 
                Object owner) {
        synchronized (map) {
            Object val = map.get(id);
            if (val != null) {
               return false;
            }
            if (owner == null) {
                owner = noOwner;
            }
            map.put(id, owner);
            return true;
        }    
    }

    public void unlockResource(String id) {
        map.remove(id);
    }

    public void freeAllLocks(Object owner) {
        synchronized (map) {
            Iterator itr = map.values().iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (o.equals(owner)) {
                    itr.remove();
                }
            }
        }
    }


    public void acknowledgeMessage(BrokerAddress address, SysMessageID mid, 
                                   ConsumerUID cid, int type, boolean ackack,
                                   Map optProp, Long txnID) throws BrokerException
    {
    }

    public void recordUpdateDestination(Destination d)
        throws BrokerException {
    }

    public void recordRemoveDestination(Destination d)
        throws BrokerException {
    }

    public void createDestination(Destination dest) 
            throws BrokerException
    {
    }

    public void recordCreateSubscription(Subscription sub)
        throws BrokerException {
    }

    public void recordUnsubscribe(Subscription sub)
        throws BrokerException {
    }

    public void createSubscription(Subscription sub, Consumer cons)
            throws BrokerException
    {
    }

    public void createConsumer(Consumer con)
            throws BrokerException {
    }

    public void updateDestination(Destination dest)
            throws BrokerException {
    }

    public void updateSubscription(Subscription sub)
            throws BrokerException {
    }

    public void updateConsumer(Consumer con)
            throws BrokerException {
    }


    public void destroyDestination(Destination dest)
            throws BrokerException {
    }

    public void destroySubscription(Subscription sub)
            throws BrokerException {
    }

    public void destroyConsumer(Consumer con)
            throws BrokerException {
    }

    public void connectionClosed(ConnectionUID uid, boolean admin) {
        freeAllLocks(uid);
    }

    public void reloadCluster() {
    }

    public boolean lockUIDPrefix(short p){
        return true;
    }
}

