/*
 * @(#)AutoRollbackType.java	1.4 07/26/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data;

import java.io.Serializable;
import java.io.ObjectStreamException;

public class AutoRollbackType implements Serializable
{

    static final long serialVersionUID = -6704477057825567951L;

    /**
     * descriptive string associated with the type
     */
    private final String name;


    /**
     * int value for the state used when reading/writing
     * the client->broker protocol.
     */
    private final int value;


    /**
     * value for ROLLBACK_ALL used with the protocol.
     */
    private static final int I_ROLLBACK_ALL=1;

    /**
     * value for ROLLBACK_NOT_PREPARED used with the protocol.
     */
    private static final int I_ROLLBACK_NOT_PREPARED=2;

    /**
     * value for ROLLBACK_NEVER used with the protocol.
     */
    private static final int I_ROLLBACK_NEVER=3;


    /**
     * mapping of type (int) values to AutoRollbackType
     */
    private static AutoRollbackType[] bs =new AutoRollbackType[3];


    /**
     * private constructor for AutoRollbackType
     */
    private AutoRollbackType(String name, int value) {
        this.name = name;
        this.value = value;
        bs[value-1]=this;
    }

    /**
     * method which takes an int (retrieved from the
     * persistent store) and converts it to a state
     */
    public static final AutoRollbackType getType(int value) 
    {
        return bs[value-1];
    }

    /**
     * method which returns the int value associated
     * with the state. This method should only be used when the
     * state written to or read from the protocol.
     */
    public int intValue()
    {
        return value;
    }

    /**
     * a string representation of the object
     */
    public String toString() {
        return "AutoRollbackType["+name+"]";
    }

    /**
     * Rollback a transaction of this type when the
     * broker is restarted.
     */
    public static final AutoRollbackType ALL = 
             new AutoRollbackType("ALL",
                      I_ROLLBACK_ALL);


    /**
     * Rollback a transaction of this type if
     * it is not in PREPARED when the broker is restarted.
     */
    public static final AutoRollbackType NOT_PREPARED = 
             new AutoRollbackType("NOT_PREPARED",
                      I_ROLLBACK_NOT_PREPARED);

    /**
     * Never rollback a transaction of this type when 
     * the broker is restarted. The transaction must be
     * COMMITTED, ROLLEDBACK or it must timeout.
     */
    public static final AutoRollbackType NEVER = 
             new AutoRollbackType("NEVER",
                      I_ROLLBACK_NEVER);


    Object readResolve() throws ObjectStreamException
    {
        return getType(value);
    }

}

