/*
 * @(#)GoodbyeHandler.java	1.32 05/19/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.io.Packet;
import java.io.IOException;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.util.timer.*;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.util.GoodbyeReason;

import java.util.*;



/**
 * Handler class which deals with a "goodbye" message which is sent 
 * when a client quits talking to the broker
 */
public class GoodbyeHandler extends PacketHandler 
{

    protected static long timeout = Globals.getConfig().getLongProperty(
             Globals.IMQ + ".goodbye.timeout", 0);

    ConnectionManager conlist = null;

    public GoodbyeHandler(ConnectionManager mgr) {
        conlist = mgr;
        timeout = Globals.getConfig().getLongProperty(
             Globals.IMQ + ".goodbye.timeout", 0);
        GoodbyeTask.initialize(timeout);
    }

    /**
     * Method to handle goodbye messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException
    {
        Hashtable props = null;
        try {
            props = msg.getProperties();
        } catch (Exception ex) {
            logger.log(Logger.INFO,"Internal Error: unable to retrieve "+
                " properties from goodbye message " + msg, ex);
            props = new Hashtable();
        }

        boolean notAuthenticated = !con.isAuthenticated();
        if (con.isValid() && notAuthenticated) {
            logger.log(Logger.WARNING,"Internal error: " +
                 " received goodbye on unauthenticated connection "
                 + con.getConnectionUID().longValue() 
                 + " " + con.getRemoteConnectionString() );
        }

        Boolean blockprop = (props != null ?(Boolean)props.get("JMQBlock") : null);
        boolean block = (blockprop != null && blockprop.booleanValue());

        // send the reply (if necessary)
        con.stopConnection();

        if (block) {
            con.cleanupConnection();
        }
        boolean destroy = false;
        if (msg.getSendAcknowledge()) {
             Packet pkt = new Packet(con.useDirectBuffers());
             pkt.setPacketType(PacketType.GOODBYE_REPLY);
             pkt.setConsumerID(msg.getConsumerID());
             Hashtable hash = new Hashtable();
             hash.put("JMQStatus", new Integer(Status.OK));
             if (con.DUMP_PACKET || con.OUT_DUMP_PACKET)
                 hash.put("JMQReqID", msg.getSysMessageID().toString());
             pkt.setProperties ( hash );
             con.sendControlMessage(pkt);
             // increase timeout 
             if (con.isBlocking()) {
                 con.flushControl(timeout);
                 destroy = true;
             } else {
                 con.setDestroyReason(
                     Globals.getBrokerResources().getKString(
                      BrokerResources.M_CLIENT_SHUTDOWN));
                 GoodbyeTask.addConnection(con.getConnectionUID(),
                     Globals.getBrokerResources().getKString(
                      BrokerResources.M_CLIENT_SHUTDOWN));
             }
        } else {
            destroy = true;
        }
        if (destroy) {
            con.destroyConnection(false /* no reply */,
                  GoodbyeReason.CLIENT_CLOSED, 
                  Globals.getBrokerResources().getKString(
                      BrokerResources.M_CLIENT_SHUTDOWN));
        }
        return true;
    }

}


class GoodbyeTask extends JMQTimerTask
{
    static Logger logger = Globals.getLogger();
    static GoodbyeTask runner = null;

    LinkedList nextSet = new LinkedList();
    LinkedList reasonSet = new LinkedList();

    static long timeout = 0;

    boolean invalid = false;
    private static synchronized GoodbyeTask get() {
        if (runner == null) {
            runner = new GoodbyeTask();
        }
        return runner;
    }

    public static void initialize(long ttl)
    {
        timeout = ttl;
    }

    private GoodbyeTask() {         
        if (timeout <= 0)
            timeout = 300*1000; // 5 minutes
        try { 
            Globals.getTimer().schedule(this, timeout,
                   timeout);
        } catch (IllegalStateException ex) {
            logger.logStack(Logger.DEBUG,"Timer canceled ", ex);
            invalid = true;
        }
    }

    private synchronized void _addCon(ConnectionUID conuid, String reason) {
        if (invalid) return;
        reasonSet.add(reason);
        nextSet.add(conuid);
    }

    public static void addConnection(ConnectionUID conuid, String reason) {
        synchronized (GoodbyeTask.class) {
            GoodbyeTask task = runner.get();
            try {
                runner.get()._addCon(conuid, reason);
            } catch (IllegalStateException ex) {
                logger.logStack(Logger.DEBUG,"Timer canceled ", ex);
            }
        }
    }
    public void run() {
        LinkedList list = null;
        synchronized(this.getClass()) {
            synchronized(this) {
                if (nextSet.isEmpty()) {
                    runner.cancel();
                    runner = null;
                } else {
                    list = nextSet;
                    nextSet = new LinkedList();
                }
            }
        }
        if (list == null) return;
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            ConnectionUID uid = (ConnectionUID)itr.next();
            IMQConnection con = (IMQConnection)Globals.getConnectionManager()
                                .getConnection(uid);
            if (con != null && con.isValid()) {
                try {
                    con.destroyConnection(false,GoodbyeReason.CLIENT_CLOSED, 
                            (String)reasonSet.removeFirst());
                } catch (Exception ex) {
                    logger.logStack(Logger.DEBUG,"error destroying connection " + con , ex);
                }
            }
            itr.remove();
        }              
    }

}
