/*
 * @(#)PingHandler.java	1.1 04/14/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import java.net.*;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryManager;



public class PingHandler extends PacketHandler 
{
    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    public static boolean DEBUG = false;

    public PingHandler()
    {
    }

    /**
     * Method to handle Acknowledgement messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException 
    { 

        if (DEBUG) {
             logger.log(Logger.DEBUGHIGH, "PingHandler: handle() [ Received Ping Message]");
        }

        if (msg.getSendAcknowledge()) {
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setPacketType(PacketType.PING_REPLY);
            pkt.setConsumerID(msg.getConsumerID());
            Hashtable hash = new Hashtable();
            int status = Status.OK;
            
            hash.put("JMQStatus", new Integer(status));
            pkt.setProperties(hash);

            con.sendControlMessage(pkt);
         }

        return true;

    }

}
