/*
 * @(#)RefCompare.java	1.3 10/06/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;

public class RefCompare implements Comparator
{
    public int compare(Object o1, Object o2)
    {
        if (o1 instanceof PacketReference &&
            o2 instanceof PacketReference) {
            PacketReference ref1 = (PacketReference) o1;
            PacketReference ref2 = (PacketReference) o2;
            // compare priority 
            long dif = ref2.getPriority() - ref1.getPriority();

            // then timestamp
            if (dif == 0)
                dif = ref1.getTimestamp() - ref2.getTimestamp();

            // then sequence
            if (dif == 0)
                dif = ref1.getSequence() - ref2.getSequence();

            if (dif < 0) return -1;
            if (dif > 0) return 1;
            return 0;
        }
        return o2.hashCode() - o1.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}
