/*
 * @(#)VerifyDestinationHandler.java	1.21 06/10/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;

import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;

import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;


/**
 * Handler class which deals with starting/stoping the delivery of 
 * messages to a specific connection
 */
public class VerifyDestinationHandler extends PacketHandler 
{

    private Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;
  

    public VerifyDestinationHandler() {
    }

    /**
     * Method to handle Destination (create or delete) messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException
    {

        int status = Status.OK;
        String reason = null;

        assert msg.getPacketType() == PacketType.VERIFY_DESTINATION;

        Packet pkt = new Packet(con.useDirectBuffers());
        pkt.setConsumerID(msg.getConsumerID());

        pkt.setPacketType(PacketType.VERIFY_DESTINATION_REPLY);

        Hashtable hash = new Hashtable();

        Hashtable props = null;
        String selectorstr = null;
        Integer destType;
        int type = 0;
        try {
            props = msg.getProperties();
            String destination = (String )props.get("JMQDestination");
            Integer inttype = (Integer )props.get("JMQDestType");

            // destination & type required
            assert destination != null;
            assert inttype != null;

            type = (inttype == null) ? 0 : inttype.intValue();
            selectorstr = (String )props.get("JMQSelector");

            if (selectorstr != null) {
                Selector selector = Selector.compile(selectorstr);
                selector = null;
            }

            Destination d =  Destination.getDestination(destination,
                       DestType.isQueue(type));

            if (d == null) {
                // not found
                status = Status.NOT_FOUND;
                reason = "destination not found";
                hash.put("JMQCanCreate", new Boolean(
                        Destination.canAutoCreate(DestType.isQueue(type))));
            } else {
                hash.put("JMQDestType", new Integer(d.getType()));
            }
            
        } catch (SelectorFormatException ex) {
            reason = ex.getMessage();
            status = Status.BAD_REQUEST;
            logger.log(Logger.WARNING,BrokerResources.W_SELECTOR_PARSE, 
                 selectorstr, ex);
        } catch (IOException ex) {
            logger.log(Logger.ERROR, BrokerResources.E_INTERNAL_BROKER_ERROR, "Unable to verify destination - no properties",ex);
            reason = ex.getMessage();
            status = Status.ERROR;
        } catch (ClassNotFoundException ex) {
            logger.logStack(Logger.ERROR, BrokerResources.E_INTERNAL_BROKER_ERROR, "Unable to verify destination -bad class",ex);
            reason = ex.getMessage();
            status = Status.ERROR;
        } catch (BrokerException ex) {
            reason = ex.getMessage();
            status = ex.getStatusCode();
            logger.logStack(Logger.DEBUG, BrokerResources.E_INTERNAL_BROKER_ERROR, "Unable to verify destination ",ex);

        } catch (SecurityException ex) {
            reason = ex.getMessage();
            status = Status.FORBIDDEN;
            logger.log(Logger.WARNING,ex.toString(), ex);
        }
    

        hash.put("JMQStatus", new Integer(status));
        if (reason != null)
            hash.put("JMQReason", reason);
        if (con.DUMP_PACKET || con.OUT_DUMP_PACKET)
            hash.put("JMQReqID", msg.getSysMessageID().toString());


        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        return true;
    }

}
