/*
 * @(#)GetClusterHandler.java	1.13 12/05/05
 *
 * Copyright 2000-2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.cluster.*;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.cluster.ha.*;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.ConsumerInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jms.management.server.BrokerClusterInfo;

public class GetClusterHandler extends AdminCmdHandler
{
    public GetClusterHandler(AdminDataHandler parent) {
    super(parent);
    }


    public static int convertState(BrokerState state)
    {
        if (state == BrokerState.INITIALIZING) {
            return com.sun.messaging.jms.management.server.BrokerState.OPERATING;
        } else if (state == BrokerState.OPERATING) {
            return com.sun.messaging.jms.management.server.BrokerState.OPERATING;
        } else if (state == BrokerState.QUIESCE_STARTED) {
            return com.sun.messaging.jms.management.server.BrokerState.QUIESCE_STARTED;
        } else if (state == BrokerState.QUIESCE_COMPLETED) {
            return com.sun.messaging.jms.management.server.BrokerState.QUIESCE_COMPLETE;
        } else if (state == BrokerState.SHUTDOWN_STARTED) {
            return com.sun.messaging.jms.management.server.BrokerState.SHUTDOWN_STARTED;
        } else if (state == BrokerState.SHUTDOWN_COMPLETE) {
            return com.sun.messaging.jms.management.server.BrokerState.BROKER_DOWN;
        } else if (state == BrokerState.SHUTDOWN_FAILOVER) {
            return com.sun.messaging.jms.management.server.BrokerState.BROKER_DOWN;
        } else if (state == BrokerState.FAILOVER_PENDING) {
            return com.sun.messaging.jms.management.server.BrokerState.BROKER_DOWN;
        } else if (state == BrokerState.FAILOVER_STARTED) {
            return com.sun.messaging.jms.management.server.BrokerState.TAKEOVER_STARTED;
        } else if (state == BrokerState.FAILOVER_COMPLETE) {
            return com.sun.messaging.jms.management.server.BrokerState.TAKEOVER_COMPLETE;
        } else if (state == BrokerState.FAILOVER_FAILED) {
            return com.sun.messaging.jms.management.server.BrokerState.TAKEOVER_FAILED;
        }
        return com.sun.messaging.jms.management.server.BrokerState.BROKER_DOWN;
    }

    public static Hashtable getBrokerClusterInfo(ClusteredBroker cb, Logger logger)  {
	Hashtable h = new Hashtable();

        String brkid;
	if (cb.isBrokerIDGenerated())  {
            brkid = "";
	} else  {
            brkid = cb.getBrokerName();
	}
        h.put(BrokerClusterInfo.ID, brkid);

        BrokerMQAddress bm = (BrokerMQAddress)cb.getBrokerURL();
        String address = bm.getHost().getHostName() + ":" + bm.getPort();
        h.put(BrokerClusterInfo.ADDRESS, address);

	/*
	 * Substitute "Version" with BrokerClusterInfo.VERSION if/when
	 * that constant is added. It's not there now because we don't
	 * want to expose version just yet - because cb.getVersion()
	 * currently returns protocol version, not broker version.
	 * A new method needs to be added to ClusteredBroker that returns the 
	 * broker version.
	 */
        h.put("Version", String.valueOf(cb.getVersion()));

        if (cb instanceof HAClusteredBroker) {
            try {
                HAClusteredBroker hcb = (HAClusteredBroker)cb;
                h.put(BrokerClusterInfo.STATUS_TIMESTAMP, new Long(hcb.getHeartbeat()));
                h.put(BrokerClusterInfo.TAKEOVER_BROKER_ID, hcb.getTakeoverBroker());
                int cnt = Globals.getStore().getMessageCount(brkid);
                h.put(BrokerClusterInfo.NUM_MSGS, new Long(cnt)); 
            } catch (Exception ex) {
            }
        }
        try {
            h.put(BrokerClusterInfo.STATE, new Integer(convertState(cb.getState())));
        } catch (Exception ex) {
	    if (logger != null)  {
                logger.logStack(Logger.INFO,
                    BrokerResources.E_INTERNAL_BROKER_ERROR,
                    "Converting state", ex);
	    }
            h.put(BrokerClusterInfo.STATE,
		new Integer(com.sun.messaging.jms.management.server.BrokerState.BROKER_DOWN));
        }

	return (h);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con    The Connection the message came in on.
     * @param cmd_msg    The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
                       Hashtable cmd_props) {

        if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                            "Getting cluster info/state: " + cmd_props);
        }


        Vector v = new Vector();
        int status = Status.OK;
        String errMsg = null;

       /*
	* Populate vector 'v' with Hashtable objects; each containing broker
	* info.
	*/
	Properties brokerProps = Globals.getConfig().toProperties();

	/*
	 * See com.sun.messaging.jms.management.BrokerClusterInfo class on how
	 * to setup the Hashtable with data to initialize the BrokerClusterInfo
	 * object.
	 */


    ClusterManager cm = Globals.getClusterManager();


    Iterator itr = cm.getKnownBrokers();

    while (itr.hasNext()) {
        ClusteredBroker cb = (ClusteredBroker)itr.next();
        Hashtable h = getBrokerClusterInfo(cb, logger);
        v.add(h);
    }

       // Send reply
       Packet reply = new Packet(con.useDirectBuffers());
       reply.setPacketType(PacketType.OBJECT_MESSAGE);
   
       setProperties(reply, MessageType.GET_CLUSTER_REPLY,
           status, errMsg);
   
       setBodyObject(reply, v);
       parent.sendReply(con, cmd_msg, reply);

       return true;
   }
}
