/*
 * @(#)GetTransactionsHandler.java	1.9 09/29/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;
import java.util.List;
import java.util.Enumeration;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;

public class GetTransactionsHandler extends AdminCmdHandler
{

    TransactionList tl = null;

    public GetTransactionsHandler(AdminDataHandler parent) {
	super(parent);
        tl = parent.tl;
    }

    public static Hashtable getTransactionInfo(TransactionList tl,
                                               TransactionUID id) {
                                               
        TransactionState ts = tl.retrieveState(id);
        if (ts == null) return null;

        JMQXid xid = tl.UIDToXid(id);

        Hashtable table = new Hashtable();
        if (xid != null) {
            table.put("xid", xid.toString());
        }

        table.put("txnid", new Long(id.longValue()));
        if (ts.getUser() != null)
            table.put("user", ts.getUser());

        if (ts.getClientID() != null) {
            table.put("clientid", ts.getClientID());
        }
        table.put("timestamp",
                new Long(System.currentTimeMillis() - id.age()));
        table.put("connection", ts.getConnectionString());

        table.put("nmsgs", new Integer(tl.retrieveNSentMessages(id)));
        table.put("nacks", new Integer(tl.retrieveNConsumedMessages(id)));
        table.put("state", new Integer(ts.getState()));

        return table;
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                            "Getting transactions " + cmd_props);
        }

        int status = Status.OK;
	String errMsg = null;
        TransactionUID tid = null;

	Long id = (Long)cmd_props.get(MessageType.JMQ_TRANSACTION_ID);

        if (id != null) {
            tid = new TransactionUID(id.longValue());
        }

        Hashtable table = null;
	Vector v = new Vector();
        if (tid != null) {
            // Get info for one transaction
            table = getTransactionInfo(tl, tid);
            if (table != null) {
                v.add(table);
            }
        } else {
            // Get info for all transactions (-1 means get transactions
            // no matter what the state).
            Vector transactions = tl.getTransactions(-1);
            if (transactions != null) {
                Enumeration e = transactions.elements();
                while (e.hasMoreElements()) {
                    tid = (TransactionUID)e.nextElement();
                    table = getTransactionInfo(tl, tid);
                    if (table != null) {
                        v.add(table);
                    }
                }
            }
        }

        if (tid != null && v.size() == 0) {
            // Specified transaction did not exist
            status = Status.NOT_FOUND;
	    errMsg = rb.getString(rb.E_NO_SUCH_TRANSACTION, tid);
        }

        // Write reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply, MessageType.GET_TRANSACTIONS_REPLY, status, errMsg);
        // Add JMQQuantity property
        try {
            reply.getProperties().put(MessageType.JMQ_QUANTITY,
                            new Integer(v.size()));
        } catch (IOException e) {
	    // Programming error. No need to I18N
	    logger.log(Logger.WARNING, rb.E_INTERNAL_BROKER_ERROR,
                "Admin: GetTransactions: Could not extract properties from pkt",
                e);
        } catch (ClassNotFoundException e) {
	    // Programming error. No need to I18N
	    logger.log(Logger.WARNING, rb.E_INTERNAL_BROKER_ERROR,
                "Admin: GetTransactions: Could not extract properties from pkt",
                e);
        }

        // Always set the body even if vector is empty
	setBodyObject(reply, v);

	parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}
