/*
 * @(#)PurgeDestinationHandler.java	1.28 10/17/05
 *
 * Copyright 2000-2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.DestType;

//XXX:Audit:Removed
//import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;

public class PurgeDestinationHandler extends AdminCmdHandler
{

    private Filter deleteAll = new DeleteAllMessages();

    public PurgeDestinationHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                "Purging: " + cmd_props);
        }

        assert cmd_props != null;
	String destination = (String)cmd_props.get(MessageType.JMQ_DESTINATION);
	Integer destType = (Integer)cmd_props.get(MessageType.JMQ_DEST_TYPE);
        assert destination != null;
        assert destType != null;
        int status = Status.OK;
        String errMsg = null;


        // FOR NOW .. we have just one criteria - ALL
        String criteria_str = Globals.getBrokerResources().getKString(
                    BrokerResources.I_ALL_PURGE_CRITERIA);

//LKS
// dont use filter for now
//        Filter f = deleteAll;

        logger.log(Logger.INFO, BrokerResources.I_PURGING_DESTINATION,
                 destination , criteria_str);

        try {
            // for now .. just delete all
            Destination d = Destination.getDestination(destination, DestType.isQueue(destType.intValue()));
            if (d == null) {
                errMsg = Globals.getBrokerResources().getKString(
                          BrokerResources.E_NO_SUCH_DESTINATION,
                          DestType.toString(destType.intValue()), destination);
                Exception e = new BrokerException(errMsg);
                e.fillInStackTrace();
                status = Status.ERROR;
                logger.log(Logger.WARNING, BrokerResources.W_ADMIN_OPERATION_FAILED,
 e);
            } else {

//XXX:Audit:Removed
//		// audit logging for purage destination
//		Globals.getAuditSession().destinationOperation(
//			con.getUserName(), con.remoteHostString(),
//			MQAuditSession.PURGE_DESTINATION,
//			d.isQueue() ? MQAuditSession.QUEUE:MQAuditSession.TOPIC,
//			d.getDestinationName());


		d.purgeDestination();
            }
        } catch (BrokerException ex) {
            status = Status.ERROR;
            errMsg = getMessageFromException(ex);
            logger.log(Logger.WARNING, BrokerResources.W_ADMIN_OPERATION_FAILED, ex);
        } catch (OutOfMemoryError err) {
            // throw memory error so it is handled by memory code
            throw err;
        } catch (Throwable ex) {
            status = Status.ERROR;
            errMsg = Globals.getBrokerResources().getString(
                    BrokerResources.X_INTERNAL_EXCEPTION, ex) ;
            logger.log(Logger.WARNING, BrokerResources.W_ADMIN_OPERATION_FAILED,
 ex);
        }

	// Send reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply, MessageType.PURGE_DESTINATION_REPLY,
		status, errMsg);

	parent.sendReply(con, cmd_msg, reply);
        return true;
    }


    
}
