/*
 * @(#)RollbackCommitHandler.java	1.6 05/23/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;
import java.util.List;
import java.util.Iterator;
import javax.transaction.xa.XAResource;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.Globals;

public class RollbackCommitHandler extends AdminCmdHandler
{

    TransactionList tl = null;

    public RollbackCommitHandler(AdminDataHandler parent) {
	super(parent);
        tl = parent.tl;
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                            "Rollback/Commit transaction " + cmd_props);
        }

        // Get the admin request message type
        int requestType =
            ((Integer)cmd_props.get(MessageType.JMQ_MESSAGE_TYPE)).intValue();
        int status = Status.OK;
	String errMsg = null;
        TransactionUID tid = null;
        TransactionState ts = null;
        TransactionHandler thandler = null;

        // Get the packet handler that handles transaction packets
        if (parent.adminPktRtr != null) {
            thandler = (TransactionHandler)
            parent.adminPktRtr.getHandler(PacketType.ROLLBACK_TRANSACTION);
        }

	Long id = (Long)cmd_props.get(MessageType.JMQ_TRANSACTION_ID);

        if (id != null) {
            tid = new TransactionUID(id.longValue());
        } else {
            status = Status.BAD_REQUEST;
        }

        if (status == Status.OK) {
            ts = tl.retrieveState(tid);
            if (ts == null) {
                // Specified transaction did not exist
                status = Status.NOT_FOUND;
	        errMsg = rb.getString(rb.E_NO_SUCH_TRANSACTION, tid);
            } else if (ts.getState() != TransactionState.PREPARED) {
                status = Status.PRECONDITION_FAILED;
	        errMsg = rb.getString(rb.E_TRANSACTION_NOT_PREPARED, tid);
            } else {
                JMQXid xid = tl.UIDToXid(tid);

                if (xid == null) {
                    errMsg = rb.getString(rb.E_INTERNAL_BROKER_ERROR,
                        "Could not find Xid for " + tid) ;
                    status = Status.ERROR;
                } else if (thandler == null) {
                    errMsg = rb.getString(rb.E_INTERNAL_BROKER_ERROR,
                        "Could not locate TransactionHandler") ;
                    status = Status.ERROR;
                } else {
                    if (requestType == MessageType.ROLLBACK_TRANSACTION) {
	                if ( DEBUG ) {
                            logger.log(Logger.DEBUG, 
                                "Rolling back " + tid + " in state " + ts);
                        }
                        try {
                            thandler.doRollback(tid, xid, null, ts, null, con);
                        } catch (BrokerException e) {
                            status = Status.ERROR;
                            errMsg = e.getMessage();
                        }
                    } else if (requestType == MessageType.COMMIT_TRANSACTION) {
	                if ( DEBUG ) {
                            logger.log(Logger.DEBUG, 
                                "Committing " + tid + " in state " + ts);
                        }
                        try {
                            thandler.doCommit(tid, xid,
                                new Integer(XAResource.TMNOFLAGS), ts, null,
                            false, con, null);
                        } catch (BrokerException e) {
                            status = Status.ERROR;
                            errMsg = e.getMessage();
                        }
                    } else {
                       // Should never happen.
                       return super.handle(con, cmd_msg, cmd_props);
                    }
                }
            }
        }

        sendReply(con, cmd_msg, requestType + 1, status, errMsg);

        return true;
    }

    private void sendReply(IMQConnection con, Packet cmd_msg,
        int replyType, int status, String errMsg) {

        // Send reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply, replyType, status, errMsg);

	parent.sendReply(con, cmd_msg, reply);

    }

}
