/*
 * @(#)JMXLogHandler.java	1.1 06/02/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.management.agent;

import java.util.Properties;
import java.io.IOException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.LogHandler;

/**
 * A LogHandler that uses the JMX infrastructure to send
 * JMX notifications to interested parties.
 *
 * @version	1.1
 *
 */
public class JMXLogHandler extends LogHandler {

    public JMXLogHandler() {
    }

    public void configure(Properties props, String prefix)
	throws IllegalArgumentException {

    }

    /**
     * Publish string to log.
     *
     * @param level	Log level message is being logged at
     * @param message	Message to write to log
     *
     */
    public void publish(int level, String message) throws IOException {
	Agent agent = Globals.getAgent();

	if (agent != null) {
	    agent.notifyLogMessage(level, message);
	}
    }

    /**
     * Open handler
     */
    public void open() throws IOException {
    }

    /**
     * Close handler
     */
    public void close() {
    }

    /**
     * Return a string description of this handler.
     */
    public String toString() {
	return this.getClass().getName();
    }
}
