/*
 * @(#)JVMMonitor.java	1.6 02/13/06
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.management.mbeans;

import javax.management.ObjectName;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanNotificationInfo;

import com.sun.messaging.jms.management.server.*;

public class JVMMonitor extends MQMBeanReadOnly  {
    private static MBeanAttributeInfo[] attrs = {
	    new MBeanAttributeInfo(JVMAttributes.FREE_MEMORY,
					Long.class.getName(),
					mbr.getString(mbr.I_JVM_ATTR_FREE_MEMORY),
					true,
					false,
					false),

	    new MBeanAttributeInfo(JVMAttributes.INIT_MEMORY,
					Long.class.getName(),
					mbr.getString(mbr.I_JVM_ATTR_INIT_MEMORY),
					true,
					false,
					false),

	    new MBeanAttributeInfo(JVMAttributes.MAX_MEMORY,
					Long.class.getName(),
					mbr.getString(mbr.I_JVM_ATTR_MAX_MEMORY),
					true,
					false,
					false),

	    new MBeanAttributeInfo(JVMAttributes.TOTAL_MEMORY,
					Long.class.getName(),
					mbr.getString(mbr.I_JVM_ATTR_TOTAL_MEMORY),
					true,
					false,
					false)
			};

    public JVMMonitor()  {
        super();
    }

    public Long getFreeMemory()  {
	return (new Long(Runtime.getRuntime().freeMemory()));
    }

    public Long getInitMemory()  {
	return (new Long(0));
    }

    public Long getMaxMemory()  {
	return (new Long(Runtime.getRuntime().maxMemory()));
    }

    public Long getTotalMemory()  {
	return (new Long(Runtime.getRuntime().totalMemory()));
    }

    public String getMBeanName()  {
	return ("JVMMonitor");
    }

    public String getMBeanDescription()  {
	return (mbr.getString(mbr.I_JVM_MON_DESC));
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo()  {
	return (attrs);
    }

    public MBeanOperationInfo[] getMBeanOperationInfo()  {
	return (null);
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo()  {
	return (null);
    }
}
