/*
 * @(#)ProducerManagerMonitor.java	1.11 02/13/06
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.management.mbeans;

import java.util.Iterator;

import javax.management.ObjectName;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanException;
import javax.management.openmbean.CompositeData;

import com.sun.messaging.jms.management.server.*;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.management.util.ProducerUtil;

public class ProducerManagerMonitor extends MQMBeanReadOnly  {
    private static MBeanAttributeInfo[] attrs = {
	    new MBeanAttributeInfo(ProducerAttributes.NUM_PRODUCERS,
					Integer.class.getName(),
					mbr.getString(mbr.I_PRD_MGR_ATTR_NUM_PRODUCERS),
					true,
					false,
					false)
			};

    private static MBeanParameterInfo[] getProducerInfoByIDSignature = {
		    new MBeanParameterInfo("producerID", String.class.getName(), 
			mbr.getString(mbr.I_PRD_MGR_OP_PARAM_PRD_ID))
			    };

    private static MBeanOperationInfo[] ops = {
	    new MBeanOperationInfo(ProducerOperations.GET_PRODUCER_IDS,
		mbr.getString(mbr.I_PRD_MGR_OP_GET_PRODUCER_IDS),
		    null , 
		    String[].class.getName(),
		    MBeanOperationInfo.INFO),

	    new MBeanOperationInfo(ProducerOperations.GET_PRODUCER_INFO,
		mbr.getString(mbr.I_PRD_MGR_OP_GET_PRODUCER_INFO),
		    null , 
		    CompositeData[].class.getName(),
		    MBeanOperationInfo.INFO),

	    new MBeanOperationInfo(ProducerOperations.GET_PRODUCER_INFO_BY_ID,
		mbr.getString(mbr.I_PRD_MGR_OP_GET_PRODUCER_INFO_BY_ID),
		    getProducerInfoByIDSignature, 
		    CompositeData.class.getName(),
		    MBeanOperationInfo.INFO)
		};
	
    public ProducerManagerMonitor()  {
	super();
    }

    public Integer getNumProducers()  {
        return (new Integer(Producer.getNumProducers()));
    }

    public String[] getProducerIDs() throws MBeanException  {
	return (ProducerUtil.getProducerIDs());
    }

    public CompositeData[] getProducerInfo() throws MBeanException {
	CompositeData cds[] = null;

	try  {
	    cds = ProducerUtil.getProducerInfo();
	} catch(Exception e)  {
	    handleOperationException(ProducerOperations.GET_PRODUCER_INFO, e);
	}

	return (cds);
    }

    public CompositeData getProducerInfoByID(String producerID) throws MBeanException  {
	CompositeData cd = null;

	try  {
	    cd = ProducerUtil.getProducerInfo(producerID);
	} catch(Exception e)  {
	    handleOperationException(ProducerOperations.GET_PRODUCER_INFO_BY_ID, e);
	}

	return (cd);
    }

    public String getMBeanName()  {
	return ("ProducerManagerMonitor");
    }

    public String getMBeanDescription()  {
	return (mbr.getString(mbr.I_PRD_MGR_MON_DESC));
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo()  {
	return (attrs);
    }

    public MBeanOperationInfo[] getMBeanOperationInfo()  {
	return (ops);
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo()  {
	return (null);
    }
}
