/*
 * @(#)Heartbeat.java	1.2 04/18/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi;

import java.io.IOException;
import java.net.InetSocketAddress;

/**
 */
public interface Heartbeat {

    /**
     * A name (can be null) for logging purpose
     */
    String
    getName();

    /**
     * A protocol string
     */
    String
    getProtocol();

    /**
     * Initialization
     *
     * @param addr bind IP address
     * @param port bind port 
     * @param cb The HeartbeatCallback
     *
     * @throws IOException if failed to initialize
     */
    void
    init(InetSocketAddress iaddr, HeartbeatCallback cb) throws IOException;

    /**
     * Stop  
     *
     * @throws IOException if failed to start
     */
    void
    stop() throws IOException;


    /**
     *
     * @param key The opaque key associated with this endpoint
     * @param addr The remote IP address
     * @param port The remote port number
     * @param dataLength The expected data length
     *
     * @throws IOException
     */
    void
    addEndpoint(Object key, InetSocketAddress iaddr, int dataLength) throws IOException;

    /**
     */
    void
    removeEndpoint(Object key, InetSocketAddress iaddr) throws IOException;

    /**
     */
    InetSocketAddress 
    getBindEndpoint();

    /**
     *
     * @param interval The inteval (in seconds) between each heartbeat
     */
    void
    setHeartbeatInterval(int interval);

    /**
     *
     * @return The heartbeat interval
     */
    int 
    getHeartbeatInterval();



    /**
     * Timeout when heartbeat message not received for period of threshold*interval
     * from a remote endpoint
     *
     * @param threshold in terms of number of times of heartbeat interval 
     */
    void
    setTimeoutThreshold(int threshold);

    /**
     *
     * @return The heartbeat timeout threshold 
     */
    int 
    getTimeoutThreshold();

}
