/*
 * @(#)InterestUpdateHandler.java	1.5 05/20/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.Iterator;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;

public class InterestUpdateHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public InterestUpdateHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG)
            logger.log(logger.DEBUG, "InterestUpdateHandler");

        if (pkt.getType() == ProtocolGlobals.G_INTEREST_UPDATE) {
            handleInterestUpdate(cb, sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_INTEREST_UPDATE_REPLY) {
            handleInterestUpdateReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, "InterestUpdateHandler " +
            "Internal error : Cannot handle this packet :" +
            pkt.toLongString());
        }
    }

    private void handleInterestUpdate(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        ClusterConsumerInfo cci = ClusterConsumerInfo.newInstance(pkt, c);
        int c = cci.getConsumerCount();
        int t = cci.getSubtype();

        ConsumerUID intid;

        try {
            Iterator itr = cci.getConsumerUIDs();
            switch (t) {
            case ProtocolGlobals.G_DURABLE_DETACH:
            case ProtocolGlobals.G_REM_INTEREST:
                while (itr.hasNext()) {
                    intid  = (ConsumerUID)itr.next();
                    Consumer cons = Consumer.getConsumer(intid);
                    if (cons != null) {
                        cb.interestRemoved(cons);
                    }
                }
                break;

            case ProtocolGlobals.G_NEW_PRIMARY_INTEREST:
                while (itr.hasNext()) {
                    intid  = (ConsumerUID)itr.next();
                    Consumer cons = Consumer.getConsumer(intid);
                    if (cons != null) {
                        cb.activeStateChanged(cons);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.logStack(logger.DEBUG, "Exception processing packet ", e);
        }
    }

    private void handleInterestUpdateReply(BrokerAddress sender, GPacket pkt) {
        logger.log(logger.DEBUG,
            "MessageBus: Received G_INTEREST_UPDATE_REPLY " +
            "from {0} : STATUS = {1}",
            sender, ((Integer) pkt.getProp("S")));
    }
}


/*
 * EOF
 */
