/*
 * @(#)MessageAckHandler.java	1.20 09/19/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import java.util.Map;
import java.util.HashMap;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;

public class MessageAckHandler extends GPacketHandler {
    public static boolean DEBUG = false;
    private FaultInjection fi = null;
    private HashMap ackCounts = null; //for fi

    public MessageAckHandler(RaptorProtocol p) {
        super(p);
        fi = FaultInjection.getInjection();
        ackCounts = new HashMap();
    }

    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == ProtocolGlobals.G_MESSAGE_ACK) {
            handleMessageAck(cb, sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_MESSAGE_ACK_REPLY) {
            handleMessageAckReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, br.E_INTERNAL_BROKER_ERROR,
                       "Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleMessageAck(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        ClusterMessageAckInfo cai = ClusterMessageAckInfo.newInstance(pkt, c);
        int ackType = cai.getAckType();
        Long txnID = cai.getTransactionID();

        if (fi.FAULT_INJECTION) {
        ClusterMessageAckInfo.CHECKFAULT(ackCounts, ackType, txnID,
        FaultInjection.MSG_REMOTE_ACK_HOME_P, FaultInjection.STAGE_1);
        }

        UID ssid = cai.getMessageStoreSessionUID();
        UID bsid = cai.getMessageBrokerSessionUID();

        SysMessageID sysid = null;
        ConsumerUID intid = null;

        if (!(ackType == ClusterGlobals.MB_MSG_TXN_PREPARE ||
              ackType == ClusterGlobals.MB_MSG_TXN_ROLLEDBACK ||
              (ackType == ClusterGlobals.MB_MSG_CONSUMED &&
               txnID != null))) {


            cai.initPayloadRead();

            try {
            sysid = cai.readPayloadSysMessageID();
            intid = cai.readPayloadConsumerUID();

            } catch (Exception e) {
            logger.logStack(logger.ERROR, br.getKString(
                   br.E_CLUSTER_READ_PACKET_EXCEPTION, pkt.toString(), sender), e);
            sendReply(sender, cai, Status.ERROR, e.getMessage());
            return;
            }

            cai.initToString(sysid, intid);
        }
        if (DEBUG) {
            logger.log(logger.DEBUGHIGH, "MessageBus: Received message ack : "+cai);
        }

        if ((ssid != null) != Globals.getHAEnabled()) {
            logger.log(logger.ERROR, br.E_INTERNAL_BROKER_ERROR,
                       "HA mode not match for message ack " + cai.toString());
            sendReply(sender, cai, Status.ERROR, "message HA mode not match");
            return;
        }
        if (p.isTakeoverTarget(selfAddress)) {
            logger.log(logger.ERROR, br.getKString(
                br.E_CLUSTER_MSG_ACK_THIS_BEING_TAKEOVER, cai.toString(), selfAddress));
            sendReply(sender, cai, Status.ERROR, br.getKString(
                br.X_CLUSTER_MSG_ACK_HOME_BEING_TAKEOVER, cai.toString(), selfAddress));
            return;
        }

        try {

        cb.processRemoteAck(sysid, intid, ackType, cai.getOptionalProps(), txnID, bsid, ssid);

        if (fi.FAULT_INJECTION) {
        ClusterMessageAckInfo.CHECKFAULT(ackCounts, ackType, txnID,
        FaultInjection.MSG_REMOTE_ACK_HOME_P, FaultInjection.STAGE_2);
        }

        sendReply(sender, cai, Status.OK, null); 

        if (fi.FAULT_INJECTION) {
        ClusterMessageAckInfo.CHECKFAULT(ackCounts, ackType, txnID,
        FaultInjection.MSG_REMOTE_ACK_HOME_P, FaultInjection.STAGE_3);
        }

        } catch (Exception e) {

        logger.logStack(logger.WARNING, br.getKString(
          br.W_CLUSTER_REMOTE_MSG_ACK_FAILED, cai.toString(), sender), e);
        if (e instanceof BrokerException) {
        sendReply(sender, cai, ((BrokerException)e).getStatusCode(), e.getMessage());
        } else {
        sendReply(sender, cai, Status.ERROR, e.getMessage());
        }

        }
    }

    private void sendReply(BrokerAddress sender, ClusterMessageAckInfo cai, int status, String reason) {
        if (cai.needReply()) {
            try {  
                c.unicast(sender, cai.getReplyGPacket(status, reason));
            }
            catch (IOException e) {
            Object args = new Object[] { ProtocolGlobals.getPacketTypeDisplayString(
                                         ProtocolGlobals.G_MESSAGE_ACK_REPLY),
                                         sender, cai.toString() };
            logger.logStack(logger.ERROR, br.getKString(
                            br.E_CLUSTER_SEND_REPLY_FAILED, args), e); 
            }
        }
    }

    public void handleMessageAckReply(BrokerAddress sender, GPacket pkt) {
        logger.log(logger.DEBUG,
            "MessageBus: Received G_MESSAGE_ACK_REPLY ("+ClusterMessageAckInfo.getAckAckType(pkt)+
            ")  from "+sender+ " : STATUS = "+ClusterMessageAckInfo.getAckAckStatus(pkt)); 
        p.receivedMessageAckReply(sender, pkt);
    }
   
}

/*
 * EOF
 */
