/*
 * @(#)HABrokerInfo.java	1.3 04/26/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.jmsserver.persist;

/**
 * This immutable object encapsulates general information about
 * a broker in an HA cluster.
 *
 * @version	1.3
 */
public final class HABrokerInfo {

    private String id;
    private String takeoverBrokerID;
    private String url;
    private int version;
    private int state;
    private long sessionID;
    private long heartbeat;

    /**
     * Constructor
     * @param id Broker ID
     * @param takeoverBrokerID Broker ID taken over the store
     * @param url the broker's URL
     * @param version the broker's version
     * @param state the broker's state
     * @param sessionID the broker's session ID
     * @param heartbeat broker's last heartbeat
     */
    public HABrokerInfo( String id, String takeoverBrokerID, String url, int version,
        int state, long sessionID, long heartbeat ) {

        this.id = id;
        this.takeoverBrokerID = ( takeoverBrokerID == null ) ? "" : takeoverBrokerID;
        this.url = url;
        this.version = version;
        this.state = state;
        this.sessionID = sessionID;
        this.heartbeat = heartbeat;
    }

    public String getId() {
        return id;
    }

    public String getTakeoverBrokerID() {
        return takeoverBrokerID;
    }

    public String getUrl() {
        return url;
    }

    public int getVersion() {
        return version;
    }

    public int getState() {
        return state;
    }

    public long getSessionID() {
        return sessionID;
    }

    public long getHeartbeat() {
        return heartbeat;
    }

    public String toString() {

        StringBuffer strBuf = new StringBuffer( 128 )
            .append( "(")
            .append( "brokerID=" ).append( id )
            .append( ", URL=" ).append( url )
            .append( ", version=" ).append( version )
            .append( ", state=" ).append( state )
            .append( ", sessionID=" ).append( sessionID )
            .append( ", takeoverBrokerID=" ).append( takeoverBrokerID )
            .append( ")");

        return strBuf.toString();
    }
}

