/*
 * @(#)TakeoverStoreInfo.java	1.3 05/23/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.jmsserver.persist;

import java.util.List;
import java.util.Date;

/**
 * This immutable object encapsulates general information about
 * the store info of the broker that is being taken over.
 *
 * @version	1.3
 */
public final class TakeoverStoreInfo {

    private String brokerID;        // Broker that is being taken over
    private List dstList;           // Local destination this broker owns
    private List msgList;           // Messages this broker owns
    private List txnList;           // Transaction this broker owns
    private long lockAcquiredTime;  // Timestamp when takeover lock is acquired
    private HABrokerInfo savedInfo; // Saved state of the broker being taken over

    /**
     * Constructor
     * @param bkrID the Broker ID that is being taken over
     * @param bkrInfo the saved state of the broker
     * @param ts timestamp when the takeover lock is acquired
     */
    public TakeoverStoreInfo( String bkrID, HABrokerInfo bkrInfo, long ts ) {

        lockAcquiredTime = ts;
        brokerID = bkrID;
        savedInfo = bkrInfo;
    }

    /**
     * Return the brokerID that is being taken over.
     * @return the brokerID that is being taken over
     */
    public final String getBrokerID() {
        return brokerID;
    }

    /**
     * Returns the timestamp when the takeover lock was acquired.
     * @return timestamp when the lock is acquired
     */
    public final long getLockAcquiredTime() {
        return lockAcquiredTime;
    }

    /**
     * Retrieve all local destinations that this broker previously owns.
     * @return a List of all local destinations that this broker owns
     */
    public final List getDestinationList() {
        return dstList;
    }

    /**
     * Retrieve all messages that this broker previously owns.
     * @return a List of all messages that this broker owns
     */
    public final List getMessageList() {
        return msgList;
    }

    /**
     * Retrieve all transactions that this broker previously owns.
     * @return a List of all transactions that this broker owns
     */
    public final List getTransactionList() {
        return txnList;
    }

    /**
     * Retrieve the saved state of broker.
     */
    public final HABrokerInfo getSavedBrokerInfo() {
        return savedInfo;
    }

    /**
     * Set local destinations that this broker previously owns.
     * @param list local destination this broker owns
     */
    public final void setDestinationList( List list ) {
        dstList = list;
    }

    /**
     * Set the transactions that this broker previously owns.
     * @param list transaction this broker owns
     */
    public final void setTransactionList( List list ) {
        txnList = list;
    }

    /**
     * Set messages that this broker previously owns.
     * @param list messages this broker owns
     */
    public final void setMessageList( List list ) {
        msgList = list;
    }
}
