/*
 * @(#)ConsumerDAO.java	1.8 08/31/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;

import java.sql.Connection;
import java.util.List;

/**
 * This class is an interface for the Consumer table which will be implemented
 * by database specific code.
 *
 * @version	1.8
 */
public interface ConsumerDAO extends BaseDAO {

    /**
     * Consumer table:
     * Holds durable subscriptions.
     *
     * CREATE TABLE MQCON<schemaVersion>[C<clusterID>|S<brokerID>] (
     *      ID		    BIGINT NOT NULL,
     *      CLIENT_ID       VARCHAR(1024),
     *      DURABLE_NAME    VARCHAR(1024),
     *      CONSUMER	    LONGVARBINARY NOT NULL,
     *      CREATED_TS      BIGINT NOT NULL,
     *      PRIMARY KEY(ID)
     * );
     *
     * ID - Long value of the ConsumerUID of the consumer object
     * CONSUMER - Serialized Consumer object
     * DURABLE_NAME - JMS durable name
     * CLIENT_ID - JMS client ID
     * CREATED_TS - Timestamp when the entry was created
     */
    public static final String TABLE_NAME_PREFIX = "MQCON" + DBConstants.SCHEMA_VERSION;
    public static final String ID_COLUMN = "ID";
    public static final String CLIENT_ID_COLUMN = "CLIENT_ID";
    public static final String DURABLE_NAME_COLUMN = "DURABLE_NAME";
    public static final String CONSUMER_COLUMN = "CONSUMER";
    public static final String CREATED_TS_COLUMN = "CREATED_TS";

    void insert( Connection conn, Consumer consumer, long createdTS ) throws BrokerException;

    void delete( Connection conn, Consumer consumer ) throws BrokerException;

    List getAllConsumers( Connection conn ) throws BrokerException;

    Consumer getConsumer( Connection conn, ConsumerUID consumerUID ) throws BrokerException;

    boolean checkConsumer( Connection conn, Consumer consumer ) throws BrokerException;
}
