/*
 * @(#)GenericDAOFactory.java	1.1 05/09/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;

/**
 * Factory for generic implementation of DAO object.
 *
 * @version	1.1
 */
public class GenericDAOFactory extends DAOFactory {

    public VersionDAO getVersionDAO() throws BrokerException {

        if ( versionDAO == null ) {
            versionDAO = new VersionDAOImpl();
        }
        return versionDAO;
    }

    public BrokerDAO getBrokerDAO() throws BrokerException {

        if ( brokerDAO == null ) {
            brokerDAO = new BrokerDAOImpl();
        }
        return brokerDAO;
    }

    public PropertyDAO getPropertyDAO() throws BrokerException {

        if ( propertyDAO == null ) {
            propertyDAO = new PropertyDAOImpl();
        }
        return propertyDAO;
    }

    public MessageDAO getMessageDAO() throws BrokerException {

        if ( messageDAO == null ) {
            messageDAO = new MessageDAOImpl();
        }
        return messageDAO;
    }

    public DestinationDAO getDestinationDAO() throws BrokerException {

        if ( destinationDAO == null ) {
            destinationDAO = new DestinationDAOImpl();
        }
        return destinationDAO;
    }

    public ConsumerDAO getConsumerDAO() throws BrokerException {

        if ( consumerDAO == null ) {
            consumerDAO = new ConsumerDAOImpl();
        }
        return consumerDAO;
    }

    public ConsumerStateDAO getConsumerStateDAO() throws BrokerException {

        if ( consumerStateDAO == null ) {
            consumerStateDAO = new ConsumerStateDAOImpl();
        }
        return consumerStateDAO;
    }

    public ConfigRecordDAO getConfigRecordDAO() throws BrokerException {

        if ( configRecordDAO == null ) {
            configRecordDAO = new ConfigRecordDAOImpl();
        }
        return configRecordDAO;
    }

    public TransactionDAO getTransactionDAO() throws BrokerException {

        if ( transactionDAO == null ) {
            transactionDAO = new TransactionDAOImpl();
        }
        return transactionDAO;
    }
}
