/*
 * @(#)Service.java	1.25 08/23/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.service;

import java.util.*;
import java.io.*;

/**
 * This interface abstracts the basic methods for sending
 * and receiving data from a client<P>
 *
 * A service will generally have some sort of socket it uses
 * to talk to the outside world, and a threading scheme to handle
 * reading in messages from clients and sending messages back out 
 * to clients
 *
 * Each service will also implement its own Connection interface.
 */

public interface Service
{

    public String getName();

    public Hashtable getDebugState();

    public int getState();

    public int getServiceType();

    public List getProducers();
    public List getConsumers();

    public int size();

    /**
     * start the service running
     */
    public void startService(boolean startPaused);

    /**
     * stop and destroy the service
     * @param all if false, disallow new connections only
     */
    public void stopService(boolean all);

    /**
     * stop allowing new connections
     */
    public void stopNewConnections() 
            throws IOException;

    /**
     * allowing new connections
     */
    public void startNewConnections() 
            throws IOException;

    /**
     * pause the service
     * @param all if true, connections as well as the service
     *            should be paused
     */
    public void pauseService(boolean all);

    /**
     * resume a paused service
     */
    public void resumeService();


    /**
     * destroy a stopped service
     */
    public void destroyService();

    /**
     * cleans up a connection of the service
     */
     public void removeConnection(ConnectionUID con, int reason, String str);

}
