/*
 * @(#)BrokerException.java	1.8 04/02/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.util;


import com.sun.messaging.jmq.io.Status;
/**
 * this is the sub-class for exceptions thrown by the broker
 */

public class BrokerException extends Exception
{
    /**
     * the "error-code" associated with the problem (if any)
     */
    private String errorID = null;

    /**
     * the status code associated with the problem (if any)
     */
    private int status = Status.ERROR;

    /**
     * create an exception with no message or root cause
     */
    public BrokerException() {
        super();
    }

    /**
     * create an exception with a message but no root cause
     *
     * @param msg the detail message
     */
    public BrokerException(String msg) {
        this(msg, null, null);
    }

    public BrokerException(String msg, int status) {
        this(msg, null, null, status);
    }
    public BrokerException(String msg, Throwable thr, int status) {
        this(msg, null, thr, status);
    }

    /**
     * create an exception with a message and a root cause
     *
     * @param msg the detail message
     * @param thr the root cause
     */
    public BrokerException(String msg, Throwable thr) {
        this(msg,  null, thr);
    }

    /**
     * create an exception with a message but no root cause
     *
     * @param msg the detail message
     */
    public BrokerException(String msg, String errcode) {
        this(msg, errcode, (Throwable) null);
    }

    /**
     * create an exception with a message and a root cause
     *
     * @param msg the detail message
     * @param thr the root cause
     */
    public BrokerException(String msg, String errcode, Throwable thr) {
        this(msg, errcode, thr, Status.ERROR);
    }

    /**
     * create an exception with a message and a root cause
     *
     * @param msg the detail message
     * @param thr the root cause
     */
    public BrokerException(String msg, String errcode, Throwable thr, int status) {
        super(msg, thr);
        this.errorID = errcode;
        this.status = status;
    }


    /**
     * retrieves the error code associated with the exception
     *
     * @returns the error code (if any)
     */
    public String getErrorCode() {
	return errorID;
    }

    /**
     * retrieves the status code associated with the exception
     *
     * @returns the status code
     */
    public int getStatusCode() {
	return status;
    }

/*
    public String toString() {
        String str = "";
        if (errorID != null)
            str += errorID + ": ";

        str += super.toString();

        if (getCause() != null)
            str += "[" + getCause().toString() +"]";

        return str;
    }

    public void printStackTrace() {
        printStackTrace(System.err);
    }

    public void printStackTrace(java.io.PrintStream s) {
        if (thr != null)
            thr.printStackTrace(s);
        else
            super.printStackTrace(s);
    }

    public void printStackTrace(java.io.PrintWriter w) {
        if (thr != null)
            thr.printStackTrace(w);
        else
            super.printStackTrace(w);
    }
*/
}
