/*
 * @(#)PacketUtil.java	1.17 03/18/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.util;

import java.io.*;
import com.sun.messaging.jmq.io.*;

/**
 * Contains static methods for retrieving information
 * from the packet
 */

public class PacketUtil
{

    public static String dumpThrowable(Throwable thr) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            thr.printStackTrace(ps);
            ps.flush();
            bos.flush();
            String str = bos.toString();
            ps.close();
            bos.close();
            return str;
        } catch (Exception ex) {
            return "Exception dumping exception " + ex;
        }
    }

    public static String dumpPacket(Packet pkt) {
        return dumpPacket(pkt,"\t");
    }

    public static String dumpPacket(Packet pkt, String prefix)
    {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            pkt.dump(ps, prefix);
            ps.flush();
            bos.flush();
            String str = bos.toString();
            ps.close();
            bos.close();
            return str;
        } catch (Exception ex) {
            return "Exception dumping packet " + ex;
        }
    }

}

