/*
 * @(#)Yellow.java	1.8 04/08/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.jmsserver.util.memory.levels;

import com.sun.messaging.jmq.jmsserver.util.memory.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.*;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.util.log.*;

public class Yellow extends Green
{

    protected static final int DEFAULT_GC_ITR = 1000;
    protected  int GcIterationCount = 0;


    public Yellow(String name) {
        super(name);
        MEMORY_NAME_KEY = BrokerResources.M_MEMORY_YELLOW;
        GcIterationCount = Globals.getConfig().getIntProperty(
                         Globals.IMQ + "." + name + ".gcitr", DEFAULT_GC_ITR);
    }

    public int getMessageCount(long freeMemory, int producers) {
       // never divide by 0
       if (producers >= 0) producers = 1;
        return super.getMessageCount(freeMemory,producers)/producers;
    }

    public long getMemory(long freeMemory, int producers) {
       // never divide by 0
       if (producers >= 0) producers = 1;
        return super.getMemory(freeMemory,producers)/producers/2;
    }

    public int gcCount() {
        return 1;
    }

    public int gcIteration() {
        return GcIterationCount;
    }

    public boolean cleanup(int cnt) {
        super.cleanup(cnt);
        logger.log(Logger.INFO,BrokerResources.I_LOW_MEMORY_FREE);
        logger.log(Logger.DEBUG,"Broker is swapping persistent/sent but un-acked  messages");
        Globals.getConnectionManager().cleanupMemory(true /* persist */);

        return true;
    }

    public boolean enter(boolean fromHigher) {
        super.enter(fromHigher);

        if (fromHigher) return false;

        MemoryGlobals.MEM_FREE_P_ACKED = true;

        return true; // change cnt/etc
    }

    public boolean leave(boolean toHigher)  {
        super.leave(toHigher);

        if (toHigher) {
            // went to higher level, do nothing
            return false;
        }

        MemoryGlobals.MEM_FREE_P_ACKED = false;

        return false; // dont bother to tell the client that the
                      // counts have changed -> it will fix itsself
    }

}



/*
 * EOF
 */
