/*
 * @(#)ServiceType.java	1.4 11/14/01
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.util;



public class ServiceType
{
    public static final int ALL = -1;
    public static final int UNKNOWN = -1;
    public static final int NORMAL = 0;
    public static final int ADMIN = 1;

    public static String getString(int type)
    {
        switch (type) {

            case NORMAL:
                return "Normal";

            case ADMIN:
                return "Administrator";

        }
        return "Unknown Service";

    }

    /**
     * @return the service type string as in config 
     */
    public static String getServiceTypeString(int type)
    {
        switch (type) {

            case NORMAL:
                return "NORMAL";

            case ADMIN:
                return "ADMIN";

        }
        return "UNKNOWN";
    }


    public static int getServiceType(String string)
    {
        if (string == null) {
            // unknown type
            
            // XXX - 9/11/00 - racer - log internal error

            return NORMAL;
        }

        if (string.equalsIgnoreCase("NORMAL"))
            return NORMAL;

        if (string.equalsIgnoreCase("ADMIN"))
            return ADMIN;

        // unknown type
            
        // XXX - 9/11/00 - racer - log internal error

        return NORMAL;

    }
}
