/*
 * @(#)DurableInfo.java	1.4 00/12/13
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.util.admin;

/**
 * DurableInfo encapsulates information about a JMQ Durable subscription.
 * It is used to pass this information between the Broker and an
 * administration client.
 *
 * This class has no updateable fields. The admin client should consider
 * it "read-only"
 *
 * @version	1.4
 *
 */
public class DurableInfo implements java.io.Serializable {

    public String	name;
    public String	clientID;
    public int		nMessages;
    public boolean      isActive;

    public ConsumerInfo consumer;

    /**
     * Constructor for Durable.
     *
     */
    public DurableInfo() {
	reset();
    }

    public void reset() {
	name = null;
	clientID = null;
	nMessages = 0;
        isActive = false;
	consumer = null;
    }

    /**
     * Return a string representation of the durable subscription. 
     *
     * @return String representation of durable subscription.
     */
    public String toString() {
	return clientID + "/" + name + ": " + consumer;
    }
}
