/*
 * @(#)OptionException.java	1.4 00/10/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.util.options;

/**
 * This exception provides information about problems
 * encountered when processing command line options.
 *
 * <P>It provides following information:
 * <UL>
 *   <LI> A string describing the error - This string is 
 *        the standard Java exception message, and is available via 
 *        getMessage().
 *   <LI>The command line option that is relevant.
 * </UL>
 **/

public class OptionException extends Exception {

    /**
     * Stored command line option
     **/
    private String option;

    /**
     * Constructs an OptionException
     */ 
    public OptionException() {
        super();
        option = null;
    }

    /** 
     * Constructs an OptionException with reason
     *
     * @param  reason        a description of the exception
     **/
    public OptionException(String reason) {
        super(reason);
        option = null;
    }

    /**
     * Gets the command line option that is relevant to the exception.
     *
     * @return the command line option
     **/
    public String getOption() {
        return (option);
    }

    /**
     * Sets the command line option that is relevant to the exception.
     *
     * @param o       the command line option
     **/
    public synchronized void setOption(String o) {
        option = o;
    }
}
