/*
 * @(#)PropertyAlreadyExistsException.java	1.3 00/10/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.util.options;

/**
 * This exception is for reporting cases where
 * the property name that is about to be written already
 * exists in the Properties object.
 **/

public class PropertyAlreadyExistsException extends OptionException {

    String propName;

    /**
     * Sets the property name causing the problem - because it alredy
     * exists in the Properties object.
     *
     * @param propName	The property name that already exists. 
     */
    public void setPropertyName(String propName)  {
	this.propName = propName;
    }

    /**
     * Returns the property name that is causing the problem.
     *
     * @return The property name causing the problem.
     */
    public String getPropertyName()  {
	return (propName);
    }
}
