/*
 * @(#)SelectorFormatException.java	1.1 03/14/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.util.selector;

import java.util.*;


/**
 * Exception thrown when an invlaid selector is encoutnered.
 *
 */
public class SelectorFormatException extends java.lang.Exception {

    String selector = null;
    int    index = -1;

    public SelectorFormatException() {
        super();
    }

    public SelectorFormatException(String message) {
        super(message);
    }

    public SelectorFormatException(String message, String selector) {
        super(message);
        this.selector = selector;
    }

    public SelectorFormatException(String message, String selector, int index) {
        super(message);
        this.selector = selector;
        this.index = index;
    }

    public String getSelector() {
        return selector;
    }

    public int getIndex() {
        return index;
    }

    public String getMessage() {

        if (selector != null) {
            if (index > -1) {
                return super.getMessage() + ": \"" + selector + "\" at pos=" +
                            index;
            } else {
                return super.getMessage() + ": \"" + selector + "\"" ;
            }
        } else {
            return super.getMessage();
        }
    }
}
