/*
 * @(#)Connection.java	1.2 05/03/15
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jms;

import javax.jms.JMSException;
import javax.jms.Session;

import com.sun.messaging.jms.notification.EventListener;

/**
 * This interafce provides the following API for the MQ applications:
 * <p>
 * 1. Provide API to create a MQ NO_ACKNOWLEDGE session.
 * <p>
 * 2. Provide API to set the connection event listener.
 * <p>
 * 3. Provide API to query broker adress and HA state.
 *
 * @version 1.0
 */
public interface Connection extends javax.jms.Connection {

    /** Creates a <CODE>Session</CODE> object.
      *
      * @param acknowledgeMode indicates whether the consumer or the
      * client will acknowledge any messages it receives;
      * Legal values are <code>Session.AUTO_ACKNOWLEDGE</code>,
      * <code>Session.CLIENT_ACKNOWLEDGE</code>,
      * <code>Session.DUPS_OK_ACKNOWLEDGE</code>, and
      * <code>com.sun.messaging.jms.Session.NO_ACKNOWLEDGE</code>
      *
      * @return a newly created  session
      *
      * @exception JMSException if the <CODE>Connection</CODE> object fails
      *                         to create a session due to some internal error or
      *                         lack of support for the specific transaction
      *                         and acknowledgement mode.
      *
      * @see Session#AUTO_ACKNOWLEDGE
      * @see Session#CLIENT_ACKNOWLEDGE
      * @see Session#DUPS_OK_ACKNOWLEDGE
      * @see com.sun.messaging.jms.Session#NO_ACKNOWLEDGE
      */

    public Session
    createSession(int acknowledgeMode) throws JMSException;

    /**
     * Set MQ connection event listener to the current connection.
     *
     * @param listener EventListener
     * @throws JMSException
     */
    public void
    setEventListener (EventListener listener) throws JMSException;

    /**
     * Get the broker's address that the connection is connected (related) to.
     *
     * @return the broker's address that the connection is connected (related)
     *         to.
     */
    public String getBrokerAddress();

    /**
     * Get the current connection state.
     *
     * @return true if the connection is connected to a HA broker.
     *         false if not connected to a HA broker.
     */
    public boolean isConnectedToHABroker();

}
