
/*
 * @(#)BrokerNotification.java	1.5 05/10/14
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

import javax.management.Notification;

/**
 * Class containing information on broker related notifications.
 * This notification is broadcasted from the relevant MBeans in a broker 
 * that is either:
 * <UL>
 * <LI>in the process of quiescing
 * <LI>in the process of shutting down
 * <LI>in the process of taking over another broker's persistence store
 * </UL>
 * 
 * With regards to the takeover related notifications, this notification is 
 * broadcasted by the broker that is performing the takeover operation, not the 
 * broker that is being taken over.
 *
 * @version     1.5 05/10/14
 * @author      Isa Hashim
 */
public class BrokerNotification extends MQNotification  {
    /** 
     * A broker has finished quiescing.
     */
    public static final String		BROKER_QUIESCE_COMPLETE = MQNotification.PREFIX
						+ "broker.quiesce.complete";

    /** 
     * A broker has started to quiesce.
     */
    public static final String		BROKER_QUIESCE_START = MQNotification.PREFIX
						+ "broker.quiesce.start";

    /** 
     * A broker has started the process of shutting down.
     */
    public static final String		BROKER_SHUTDOWN_START = MQNotification.PREFIX
						+ "broker.shutdown.start";

    /** 
     * A broker has completed the takeover of another broker.
     */
    public static final String		BROKER_TAKEOVER_COMPLETE = MQNotification.PREFIX
						+ "broker.takeover.complete";

    /** 
     * A broker has failed in the attempt to takeover another broker.
     */
    public static final String		BROKER_TAKEOVER_FAIL = MQNotification.PREFIX
						+ "broker.takeover.fail";

    /** 
     * A broker has started to takeover another broker.
     */
    public static final String		BROKER_TAKEOVER_START = MQNotification.PREFIX
						+ "broker.takeover.start";

    private String brokerID, brokerAddress, failedBrokerID;

    /**
     * Creates a BrokerNotification object.
     *
     * @param type		The notification type.
     * @param source		The notification source.
     * @param sequenceNumber	The notification sequence number within the source object.
     */
    public BrokerNotification(String type, Object source, long sequenceNumber) {
	super(type, source, sequenceNumber);
    }

    /**
     * Sets the broker ID. Depending on the type of notification, this can be
     * the ID of the broker that is quiescing, shutting down, or the ID of the
     * broker that is taking over another broker's persistence store.
     *
     * @param brokerID	The broker ID.
     */
    public void setBrokerID(String brokerID)  {
	this.brokerID = brokerID;
    }

    /**
     * Returns the broker ID. Depending on the type of notification, this can be
     * the ID of the broker that is quiescing, shutting down, or the ID of the
     * broker that is taking over another broker's persistence store.
     *
     * @return The broker ID.
     */
    public String getBrokerID()  {
	return(brokerID);
    }

    /**
     * Sets the broker address. Depending on the type of notification, this can be
     * the address of the broker that is quiescing, shutting down, or the address 
     * of the broker that is taking over another broker's persistence store.
     *
     * @param brokerAddress	The broker address.
     */
    public void setBrokerAddress(String brokerAddress)  {
	this.brokerAddress = brokerAddress;
    }

    /**
     * Returns the broker address. Depending on the type of notification, this 
     * can be the address of the broker that is quiescing, shutting down, or the 
     * address of the broker that is taking over another broker's persistence store.
     *
     * @return The broker address.
     */
    public String getBrokerAddress()  {
	return(brokerAddress);
    }

    /**
     * Sets the ID of the broker in the cluster that failed and is in the
     * process of being taken over.
     *
     * @param failedBrokerID	Sets the ID of the broker in the cluster 
     *				that failed and is in the process of being 
     *				taken over.
     */
    public void setFailedBrokerID(String failedBrokerID)  {
	this.failedBrokerID = failedBrokerID;
    }

    /**
     * Returns the ID of the broker in the cluster that failed and is in the
     * process of being taken over.
     *
     * @return	Sets the ID of the broker in the cluster 
     *		that failed and is in the process of being 
     *		taken over.
     */
    public String getFailedBrokerID()  {
	return(failedBrokerID);
    }
}
