
/*
 * @(#)DestinationNotification.java	1.4 05/08/08
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

import javax.management.Notification;

/**
 * Class containing information on consumer notifications.
 *
 * <P>
 * The MQ specific fields in this notification is TBD.
 *
 * @version     1.4 05/08/08
 * @author      Isa Hashim
 */
public class DestinationNotification extends MQNotification  {
    /** 
     * A destination was compacted.
     */
    public static final String		DESTINATION_COMPACT = MQNotification.PREFIX + "destination.compact";

    /** 
     * A destination was created.
     */
    public static final String		DESTINATION_CREATE = MQNotification.PREFIX + "destination.create";

    /** 
     * A destination was destroyed.
     */
    public static final String		DESTINATION_DESTROY = MQNotification.PREFIX + "destination.destroy";

    /** 
     * A destination was paused.
     */
    public static final String		DESTINATION_PAUSE = MQNotification.PREFIX + "destination.pause";

    /** 
     * A destination was purged.
     */
    public static final String		DESTINATION_PURGE = MQNotification.PREFIX + "destination.purge";

    /** 
     * A destination was resumed.
     */
    public static final String		DESTINATION_RESUME = MQNotification.PREFIX + "destination.resume";

    private String		destName;
    private String		destType;
    private String		pauseType;
    private boolean		createdByAdmin;

    /**
     * Creates a DestinationNotification object.
     *
     * @param type		The notification type.
     * @param source		The notification source.
     * @param sequenceNumber	The notification sequence number within the source object.
     */
    public DestinationNotification(String type, Object source, long sequenceNumber) {
	super(type, source, sequenceNumber);
    }

    public void setDestinationName(String name)  {
	destName = name;
    }
    public String getDestinationName()  {
	return(destName);
    }

    public void setDestinationType(String type)  {
	destType = type;
    }
    public String getDestinationType()  {
	return(destType);
    }

    public void setPauseType(String pauseType)  {
	this.pauseType = pauseType;
    }
    public String getPauseType()  {
	return(pauseType);
    }

    public void setCreatedByAdmin(boolean createdByAdmin)  {
	this.createdByAdmin = createdByAdmin;
    }
    public boolean getCreatedByAdmin()  {
	return(createdByAdmin);
    }

}
