
/*
 * @(#)DestinationPauseType.java	1.2 05/08/08
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing constants for destination pause type.
 *
 * @version     1.2 05/08/08
 * @author      Isa Hashim
 */
public class DestinationPauseType {
    /** 
     * Pauses delivery of messages from producers
     */
    public static final String PRODUCERS = "PRODUCERS";

    /** 
     * Pauses delivery of messages to consumers
     */
    public static final String CONSUMERS = "CONSUMERS";

    /** 
     * Pauses delivery of messages to consumers and from producers.
     */
    public static final String ALL = "ALL";

    /*
     * Class cannot be instantiated
     */
    private DestinationPauseType() {
    }
}
