
/*
 * @(#)LogNotification.java	1.5 05/08/08
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

import javax.management.Notification;

/**
 * Class containing information on log related notifications.
 * Log Notifications are sent when an entry in the broker log is made.
 * 
 * @version     1.5 05/08/08
 * @author      Isa Hashim
 */
public class LogNotification extends MQNotification  {
    public static final String		LOG_LEVEL_PREFIX = MQNotification.PREFIX 
						+ "log.level.";

    public static final String		LOG_LEVEL_WARNING = LOG_LEVEL_PREFIX
						+ LogLevel.WARNING;

    public static final String		LOG_LEVEL_ERROR = LOG_LEVEL_PREFIX
						+ LogLevel.ERROR;

    public static final String		LOG_LEVEL_INFO = LOG_LEVEL_PREFIX
						+ LogLevel.INFO;

    private String message;
    private String level;

    /**
     * Creates a LogNotification object.
     *
     * @param type		The notification type.
     * @param source		The notification source.
     * @param sequenceNumber	The notification sequence number within the source object.
     */
    public LogNotification(String type, Object source, long sequenceNumber) {
	super(type, source, sequenceNumber);
    }

    /**
     * Sets the message related to this log notification.
     *
     * @param msg The log message for this notification.
     */
    public void setMessage(String msg)  {
	this.message = msg;
    }
    /**
     * Returns message related to this log notification.
     *
     * @return The log message for this notification.
     */
    public String getMessage()  {
	return (message);
    }

    /**
     * Sets the log level related to this log notification.
     *
     * @param level The log level for this notification.
     */
    public void setLevel(String level)  {
	this.level = level;
    }
    /**
     * Returns the log level related to this log notification.
     *
     * @return The log level for this notification.
     */
    public String getLevel()  {
	return (level);
    }
}
