/*
 * @(#)registry.c	1.4 02/02/14
 * 
 * Copyright (c) 1998-2000 Sun Microsystems, Inc.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <winreg.h>
#include "registry.h"

// VMs to use. Order is most desireable to least desireable.
// Relative paths are assumed to be relative to jrehome/bin
char *vm_libs[] = {
        "server\\jvm.dll",
        "hotspot\\jvm.dll",
        "client\\jvm.dll",
        "classic\\jvm.dll",
        };
int nvm_libs = sizeof (vm_libs) / sizeof(char *);

int saveStringInRegistry(const char *value, long value_size, const char* name)
{
    long result;
    HKEY hKey;
    DWORD disposition;

    /*
     * Get a handle to the service parameters key. It will be something like
     * HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\IMQBroker\Parameters
     */
    result = RegCreateKeyEx(
        HKEY_LOCAL_MACHINE,
        PARAM_KEY_PATH,
        0,
        "LocalSystem",
        REG_OPTION_NON_VOLATILE,
        KEY_ALL_ACCESS,
        NULL,
        (PHKEY)&hKey,
        (LPDWORD)&disposition);

    if (result != ERROR_SUCCESS) {
        return result;
    }

    /* Set the subkey and value */
    result = RegSetValueEx(
        hKey,
        name,
        0,
        REG_SZ,
        value,
        value_size);

    if (result != ERROR_SUCCESS) {
        return result;
    }

    RegCloseKey(hKey);
}

int getStringFromRegistry(char *value, long *value_size_p, const char* name)
{
    long result;
    HKEY hKey;
    long type;

    /*
     * Get a handle to the service parameters key. It will be something like
     * HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\IMQBroker\Parameters
     */
    result = RegOpenKeyEx(
        HKEY_LOCAL_MACHINE,
        PARAM_KEY_PATH,
        0,
        KEY_READ,
        (PHKEY)&hKey
        );

    if (result != ERROR_SUCCESS) {
        return result;
    }

    /* Get the subkey and value */
    result = RegQueryValueEx(
        hKey,
        name,
        0,
        &type,
        value,
        value_size_p);

    if (result != ERROR_SUCCESS) {
        return result;
    }

    RegCloseKey(hKey);
}
