/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.internal.net.DNS;

import com.sun.jndi.internal.net.DNS.DnsClient;

class Packet {
    byte[] buf;
    int index;

    Packet(byte[] byArray, int n) {
        this.buf = new byte[n];
        System.arraycopy(byArray, 0, this.buf, 0, n);
        this.index = 0;
    }

    int getByte(int n) {
        if (this.index + n >= this.buf.length) {
            DnsClient.dprint("index " + this.index + ", offset " + n + ", >= length " + this.buf.length);
        }
        return this.buf[this.index + n] & 0xFF;
    }

    int getHeaderOffset() {
        return this.index;
    }

    int getInt(int n) {
        return this.getShort(n) << 16 | this.getShort(n + 2);
    }

    int getShort(int n) {
        return (this.buf[this.index + n] & 0xFF) << 8 | this.buf[this.index + n + 1] & 0xFF;
    }

    void putByte(int n, int n2) {
        this.buf[this.index + n2] = (byte)n;
    }

    void putBytes(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n, this.buf, this.index + n2, n3);
    }

    void putInt(int n, int n2) {
        this.buf[this.index + n2] = (byte)(n >> 24);
        this.buf[this.index + n2 + 1] = (byte)(n >> 16);
        this.buf[this.index + n2 + 2] = (byte)(n >> 8);
        this.buf[this.index + n2 + 3] = (byte)n;
    }

    void putShort(int n, int n2) {
        this.buf[this.index + n2] = (byte)(n >> 8);
        this.buf[this.index + n2 + 1] = (byte)n;
    }

    void recycle() {
    }

    void setHeaderOffset(int n) {
        this.index = n;
    }

    void shiftHeader(int n) {
        this.index += n;
    }
}

