/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class BaseDAOImpl
implements DBConstants,
BaseDAO {
    protected Logger logger = Globals.getLogger();
    protected BrokerResources br = Globals.getBrokerResources();
    protected BrokerConfig config = Globals.getConfig();

    public void createTable(Connection connection) throws BrokerException {
        String string = this.getTableName();
        this.logger.logToAll(8, this.br.getString("B1162", string));
        DBManager dBManager = DBManager.getDBManager();
        HashMap hashMap = dBManager.getTableSchema();
        DBManager.TableSchema tableSchema = (DBManager.TableSchema)hashMap.get(string);
        if (tableSchema == null || tableSchema.tableSQL.length() == 0) {
            throw new BrokerException(this.br.getKString("B3127", this.getTableNamePrefix()));
        }
        boolean bl = false;
        Statement statement = null;
        String string2 = null;
        try {
            if (connection == null) {
                connection = dBManager.getConnection(true);
                bl = true;
            }
            statement = connection.createStatement();
            string2 = tableSchema.tableSQL;
            statement.executeUpdate(string2);
            Iterator iterator = tableSchema.indexIterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                string2 = tableSchema.getIndex(string3);
                this.logger.logToAll(8, this.br.getString("B1163", string3));
                statement.executeUpdate(string2);
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4236", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, statement, connection);
            } else {
                Util.close(null, statement, null);
            }
        }
    }

    public void dropTable(Connection connection) throws BrokerException {
        String string = this.getTableName();
        this.logger.logToAll(8, this.br.getString("B1164", string));
        boolean bl = false;
        String string2 = "DROP TABLE " + string;
        Statement statement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            statement = connection.createStatement();
            statement.executeUpdate(string2);
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + string2 + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4237", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, statement, connection);
            } else {
                Util.close(null, statement, null);
            }
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        this.deleteAll(connection, null);
    }

    protected void deleteAll(Connection connection, String string, String string2, int n) throws BrokerException {
        if (n > 0) {
            this.deleteAllInChunk(connection, string, string2, n);
        } else {
            this.deleteAll(connection, string);
        }
    }

    private void deleteAll(Connection connection, String string) throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        String string2 = this.getTableName();
        String string3 = null;
        string3 = dBManager.isOracle() ? new StringBuffer(128).append("TRUNCATE TABLE ").append(string2).toString() : new StringBuffer(128).append("DELETE FROM ").append(string2).append(string != null && string.length() > 0 ? " WHERE " + string : "").toString();
        boolean bl = false;
        Statement statement = null;
        try {
            if (connection == null) {
                connection = dBManager.getConnection(true);
                bl = true;
            }
            statement = connection.createStatement();
            statement.executeUpdate(string3);
        }
        catch (SQLException sQLException) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException2) {
                this.logger.log(32, "B4080", sQLException2);
            }
            SQLException sQLException3 = DBManager.wrapSQLException("[" + string3 + "]", sQLException);
            throw new BrokerException(this.br.getKString("B4174", string2), sQLException3);
        }
        finally {
            if (bl) {
                Util.close(null, statement, connection);
            } else {
                Util.close(null, statement, null);
            }
        }
    }

    private void deleteAllInChunk(Connection connection, String string, String string2, int n) throws BrokerException {
        int n2;
        block37: {
            PreparedStatement preparedStatement;
            block34: {
                Object object;
                String string3;
                boolean bl;
                String string4;
                block32: {
                    block36: {
                        block33: {
                            int n3;
                            block30: {
                                block35: {
                                    block31: {
                                        if (string == null) {
                                            string = "";
                                        }
                                        string4 = this.getTableName();
                                        bl = false;
                                        preparedStatement = null;
                                        string3 = null;
                                        n2 = -1;
                                        DBManager dBManager = DBManager.getDBManager();
                                        if (connection == null) {
                                            connection = dBManager.getConnection(true);
                                            bl = true;
                                        } else if (!connection.getAutoCommit()) {
                                            connection.setAutoCommit(true);
                                        }
                                        string3 = new StringBuffer(128).append("SELECT COUNT(*)").append(" FROM ").append(string4).append(string.length() > 0 ? " WHERE " + string : "").toString();
                                        preparedStatement = connection.prepareStatement(string3);
                                        object = preparedStatement.executeQuery();
                                        n3 = 0;
                                        if (object.next()) {
                                            n3 = object.getInt(1);
                                        }
                                        Util.close((ResultSet)object, preparedStatement, null);
                                        if (n3 != 0) break block30;
                                        if (!bl) break block31;
                                        Util.close(null, preparedStatement, connection);
                                        break block35;
                                    }
                                    Util.close(null, preparedStatement, null);
                                }
                                if (n2 != -1) {
                                    try {
                                        connection.setTransactionIsolation(n2);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return;
                            }
                            if (n3 >= n) break block32;
                            this.deleteAll(connection, string);
                            if (!bl) break block33;
                            Util.close(null, preparedStatement, connection);
                            break block36;
                        }
                        Util.close(null, preparedStatement, null);
                    }
                    if (n2 != -1) {
                        try {
                            connection.setTransactionIsolation(n2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return;
                }
                try {
                    string3 = new StringBuffer(128).append("SELECT ").append(string2).append(" FROM ").append(string4).append(string.length() > 0 ? " WHERE " + string : "").append(" ORDER BY ").append(string2).toString();
                    preparedStatement = connection.prepareStatement(string3);
                    object = preparedStatement.executeQuery();
                    List list = Util.getChunkDelimiters((ResultSet)object, 1, n);
                    Util.close((ResultSet)object, preparedStatement, null);
                    n2 = connection.getTransactionIsolation();
                    if (n2 != 2) {
                        connection.setTransactionIsolation(2);
                    }
                    string3 = new StringBuffer(128).append("DELETE FROM ").append(string4).append(" WHERE ").append(string2).append(" < ?").append(string.length() > 0 ? " AND " + string : "").toString();
                    preparedStatement = connection.prepareStatement(string3);
                    Long[] longArray = list.toArray(new Long[0]);
                    int n4 = longArray.length;
                    for (int i = 0; i < n4; ++i) {
                        preparedStatement.setLong(1, longArray[i]);
                        preparedStatement.executeUpdate();
                    }
                    if (!bl) break block34;
                }
                catch (SQLException sQLException) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException2) {
                            this.logger.log(32, "B4080", sQLException2);
                        }
                        object = DBManager.wrapSQLException("[" + string3 + "]", sQLException);
                        throw new BrokerException(this.br.getKString("B4174", string4), (Throwable)object);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        if (n2 != -1) {
                            try {
                                connection.setTransactionIsolation(n2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block37;
            }
            Util.close(null, preparedStatement, null);
        }
        if (n2 != -1) {
            try {
                connection.setTransactionIsolation(n2);
            }
            catch (Exception exception) {}
        }
    }
}

