/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.group.MapEntry;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

class ReadThread
extends SelectThread {
    int selector_cnt = 0;

    public ReadThread(Service service, MapEntry mapEntry) throws IOException {
        super(service, mapEntry);
        this.type = "read";
        this.INITIAL_KEY = 1;
        this.POSSIBLE_MASK = 1;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("TYPE", "ReadThread");
        hashtable.put("selector_cnt", new Integer(this.selector_cnt));
        return hashtable;
    }

    protected void wakeup() {
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    protected void process() throws IOException {
        Selector selector = this.selector;
        if (selector == null) {
            throw new IOException("connection gone");
        }
        int n = 0;
        try {
            n = selector.select(this.TIMEOUT);
        }
        catch (CancelledKeyException cancelledKeyException) {
            return;
        }
        if (n > 0) {
            Set<SelectionKey> set = selector.selectedKeys();
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                IMQConnection iMQConnection = (IMQConnection)selectionKey.attachment();
                try {
                    int n2 = iMQConnection.readData();
                    iterator.remove();
                }
                catch (IOException iOException) {
                    String string = iMQConnection.getDestroyReason() == null ? (iOException instanceof EOFException ? Globals.getBrokerResources().getKString("B0061") : iOException.toString()) : iMQConnection.getDestroyReason();
                    this.removeConnection(iMQConnection, string);
                    iterator.remove();
                }
            }
        }
    }
}

